from __future__ import annotations

from enum import Enum


# Azure PII Types
# Research Page:
# https://azuresdkdocs.blob.core.windows.net/$web/python/azure-ai-textanalytics/latest/
# azure.ai.textanalytics.html#azure.ai.textanalytics.TextAnalyticsClient.recognize_pii_entities


class AzureDetectionType(Enum):
    """
    The values fed into the Azure service for detection
    """

    ABA_ROUTING_NUMBER: str = "ABARoutingNumber"
    ADDRESS: str = "Address"
    AGE: str = "Age"
    AR_NATIONAL_IDENTITY_NUMBER: str = "ARNationalIdentityNumber"
    AT_IDENTITY_CARD: str = "ATIdentityCard"
    AT_TAX_IDENTIFICATION_NUMBER: str = "ATTaxIdentificationNumber"
    AT_VALUE_ADDED_TAX_NUMBER: str = "ATValueAddedTaxNumber"
    AU_BANK_ACCOUNT_NUMBER: str = "AUBankAccountNumber"
    AU_BUSINESS_NUMBER: str = "AUBusinessNumber"
    AU_COMPANY_NUMBER: str = "AUCompanyNumber"
    AU_DRIVERS_LICENSE_NUMBER: str = "AUDriversLicenseNumber"
    AU_MEDICAL_ACCOUNT_NUMBER: str = "AUMedicalAccountNumber"
    AU_PASSPORT_NUMBER: str = "AUPassportNumber"
    AU_TAX_FILE_NUMBER: str = "AUTaxFileNumber"
    AZURE_DOCUMENT_DB_AUTH_KEY: str = "AzureDocumentDBAuthKey"
    AZURE_IAAS_DATABASE_CONNECTION_AND_SQL_STRING: str = (
        "AzureIAASDatabaseConnectionAndSQLString"
    )
    AZURE_IO_T_CONNECTION_STRING: str = "AzureIoTConnectionString"
    AZURE_PUBLISH_SETTING_PASSWORD: str = "AzurePublishSettingPassword"
    AZURE_REDIS_CACHE_STRING: str = "AzureRedisCacheString"
    AZURE_SAS: str = "AzureSAS"
    AZURE_SERVICE_BUS_STRING: str = "AzureServiceBusString"
    AZURE_STORAGE_ACCOUNT_GENERIC: str = "AzureStorageAccountGeneric"
    AZURE_STORAGE_ACCOUNT_KEY: str = "AzureStorageAccountKey"
    BE_NATIONAL_NUMBER: str = "BENationalNumber"
    BE_NATIONAL_NUMBER_V2: str = "BENationalNumberV2"
    BE_VALUE_ADDED_TAX_NUMBER: str = "BEValueAddedTaxNumber"
    BG_UNIFORM_CIVIL_NUMBER: str = "BGUniformCivilNumber"
    BRCPF_NUMBER: str = "BRCPFNumber"
    BR_LEGAL_ENTITY_NUMBER: str = "BRLegalEntityNumber"
    BR_NATIONAL_IDRG: str = "BRNationalIDRG"
    CA_BANK_ACCOUNT_NUMBER: str = "CABankAccountNumber"
    CA_DRIVERS_LICENSE_NUMBER: str = "CADriversLicenseNumber"
    CA_HEALTH_SERVICE_NUMBER: str = "CAHealthServiceNumber"
    CA_PASSPORT_NUMBER: str = "CAPassportNumber"
    CA_PERSONAL_HEALTH_IDENTIFICATION: str = "CAPersonalHealthIdentification"
    CA_SOCIAL_INSURANCE_NUMBER: str = "CASocialInsuranceNumber"
    CH_SOCIAL_SECURITY_NUMBER: str = "CHSocialSecurityNumber"
    CL_IDENTITY_CARD_NUMBER: str = "CLIdentityCardNumber"
    CN_RESIDENT_IDENTITY_CARD_NUMBER: str = "CNResidentIdentityCardNumber"
    CREDIT_CARD_NUMBER: str = "CreditCardNumber"
    CY_IDENTITY_CARD: str = "CYIdentityCard"
    CY_TAX_IDENTIFICATION_NUMBER: str = "CYTaxIdentificationNumber"
    CZ_PERSONAL_IDENTITY_NUMBER: str = "CZPersonalIdentityNumber"
    CZ_PERSONAL_IDENTITY_V2: str = "CZPersonalIdentityV2"
    DATE: str = "Date"
    DEFAULT: str = "Default"
    DE_DRIVERS_LICENSE_NUMBER: str = "DEDriversLicenseNumber"
    DE_IDENTITY_CARD_NUMBER: str = "DEIdentityCardNumber"
    DE_PASSPORT_NUMBER: str = "DEPassportNumber"
    DE_TAX_IDENTIFICATION_NUMBER: str = "DETaxIdentificationNumber"
    DE_VALUE_ADDED_NUMBER: str = "DEValueAddedNumber"
    DK_PERSONAL_IDENTIFICATION_NUMBER: str = "DKPersonalIdentificationNumber"
    DK_PERSONAL_IDENTIFICATION_V2: str = "DKPersonalIdentificationV2"
    DRUG_ENFORCEMENT_AGENCY_NUMBER: str = "DrugEnforcementAgencyNumber"
    EE_PERSONAL_IDENTIFICATION_CODE: str = "EEPersonalIdentificationCode"
    EMAIL_ADDRESS: str = "Email"
    ES_DNI: str = "ESDNI"
    ES_SOCIAL_SECURITY_NUMBER: str = "ESSocialSecurityNumber"
    ES_TAX_IDENTIFICATION_NUMBER: str = "ESTaxIdentificationNumber"
    EUGPS_COORDINATES: str = "EUGPSCoordinates"
    EU_DEBIT_CARD_NUMBER: str = "EUDebitCardNumber"
    EU_DRIVERS_LICENSE_NUMBER: str = "EUDriversLicenseNumber"
    EU_NATIONAL_IDENTIFICATION_NUMBER: str = "EUNationalIdentificationNumber"
    EU_PASSPORT_NUMBER: str = "EUPassportNumber"
    EU_SOCIAL_SECURITY_NUMBER: str = "EUSocialSecurityNumber"
    EU_TAX_IDENTIFICATION_NUMBER: str = "EUTaxIdentificationNumber"
    FI_EUROPEAN_HEALTH_NUMBER: str = "FIEuropeanHealthNumber"
    FI_NATIONAL_ID: str = "FINationalID"
    FI_NATIONAL_IDV2: str = "FINationalIDV2"
    FI_PASSPORT_NUMBER: str = "FIPassportNumber"
    FR_DRIVERS_LICENSE_NUMBER: str = "FRDriversLicenseNumber"
    FR_HEALTH_INSURANCE_NUMBER: str = "FRHealthInsuranceNumber"
    FR_NATIONAL_ID: str = "FRNationalID"
    FR_PASSPORT_NUMBER: str = "FRPassportNumber"
    FR_SOCIAL_SECURITY_NUMBER: str = "FRSocialSecurityNumber"
    FR_TAX_IDENTIFICATION_NUMBER: str = "FRTaxIdentificationNumber"
    FR_VALUE_ADDED_TAX_NUMBER: str = "FRValueAddedTaxNumber"
    GR_NATIONAL_IDV2: str = "GRNationalIDV2"
    GR_NATIONAL_ID_CARD: str = "GRNationalIDCard"
    GR_TAX_IDENTIFICATION_NUMBER: str = "GRTaxIdentificationNumber"
    HK_IDENTITY_CARD_NUMBER: str = "HKIdentityCardNumber"
    HR_IDENTITY_CARD_NUMBER: str = "HRIdentityCardNumber"
    HR_NATIONAL_ID_NUMBER: str = "HRNationalIDNumber"
    HR_PERSONAL_IDENTIFICATION_NUMBER: str = "HRPersonalIdentificationNumber"
    HR_PERSONAL_IDENTIFICATION_OIB_NUMBER_V2: str = (
        "HRPersonalIdentificationOIBNumberV2"
    )
    HU_PERSONAL_IDENTIFICATION_NUMBER: str = "HUPersonalIdentificationNumber"
    HU_TAX_IDENTIFICATION_NUMBER: str = "HUTaxIdentificationNumber"
    HU_VALUE_ADDED_NUMBER: str = "HUValueAddedNumber"
    ID_IDENTITY_CARD_NUMBER: str = "IDIdentityCardNumber"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER: str = "IEPersonalPublicServiceNumber"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER_V2: str = "IEPersonalPublicServiceNumberV2"
    IL_BANK_ACCOUNT_NUMBER: str = "ILBankAccountNumber"
    IL_NATIONAL_ID: str = "ILNationalID"
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER: str = "InternationalBankingAccountNumber"
    IN_PERMANENT_ACCOUNT: str = "INPermanentAccount"
    IN_UNIQUE_IDENTIFICATION_NUMBER: str = "INUniqueIdentificationNumber"
    IP_ADDRESS: str = "IPAddress"
    IT_DRIVERS_LICENSE_NUMBER: str = "ITDriversLicenseNumber"
    IT_FISCAL_CODE: str = "ITFiscalCode"
    IT_VALUE_ADDED_TAX_NUMBER: str = "ITValueAddedTaxNumber"
    JP_BANK_ACCOUNT_NUMBER: str = "JPBankAccountNumber"
    JP_DRIVERS_LICENSE_NUMBER: str = "JPDriversLicenseNumber"
    JP_MY_NUMBER_CORPORATE: str = "JPMyNumberCorporate"
    JP_MY_NUMBER_PERSONAL: str = "JPMyNumberPersonal"
    JP_PASSPORT_NUMBER: str = "JPPassportNumber"
    JP_RESIDENCE_CARD_NUMBER: str = "JPResidenceCardNumber"
    JP_RESIDENT_REGISTRATION_NUMBER: str = "JPResidentRegistrationNumber"
    JP_SOCIAL_INSURANCE_NUMBER: str = "JPSocialInsuranceNumber"
    KR_RESIDENT_REGISTRATION_NUMBER: str = "KRResidentRegistrationNumber"
    LT_PERSONAL_CODE: str = "LTPersonalCode"
    LU_NATIONAL_IDENTIFICATION_NUMBER_NATURAL: str = (
        "LUNationalIdentificationNumberNatural"
    )
    LU_NATIONAL_IDENTIFICATION_NUMBER_NON_NATURAL: str = (
        "LUNationalIdentificationNumberNonNatural"
    )
    LV_PERSONAL_CODE: str = "LVPersonalCode"
    MT_IDENTITY_CARD_NUMBER: str = "MTIdentityCardNumber"
    MT_TAX_ID_NUMBER: str = "MTTaxIDNumber"
    MY_IDENTITY_CARD_NUMBER: str = "MYIdentityCardNumber"
    NL_CITIZENS_SERVICE_NUMBER: str = "NLCitizensServiceNumber"
    NL_CITIZENS_SERVICE_NUMBER_V2: str = "NLCitizensServiceNumberV2"
    NL_TAX_IDENTIFICATION_NUMBER: str = "NLTaxIdentificationNumber"
    NL_VALUE_ADDED_TAX_NUMBER: str = "NLValueAddedTaxNumber"
    NO_IDENTITY_NUMBER: str = "NOIdentityNumber"
    NZ_BANK_ACCOUNT_NUMBER: str = "NZBankAccountNumber"
    NZ_DRIVERS_LICENSE_NUMBER: str = "NZDriversLicenseNumber"
    NZ_INLAND_REVENUE_NUMBER: str = "NZInlandRevenueNumber"
    NZ_MINISTRY_OF_HEALTH_NUMBER: str = "NZMinistryOfHealthNumber"
    NZ_SOCIAL_WELFARE_NUMBER: str = "NZSocialWelfareNumber"
    ORGANIZATION: str = "Organization"
    PERSON: str = "Person"
    PHONE_NUMBER: str = "PhoneNumber"
    PH_UNIFIED_MULTI_PURPOSE_ID_NUMBER: str = "PHUnifiedMultiPurposeIDNumber"
    PLREGON_NUMBER: str = "PLREGONNumber"
    PL_IDENTITY_CARD: str = "PLIdentityCard"
    PL_NATIONAL_ID: str = "PLNationalID"
    PL_NATIONAL_IDV2: str = "PLNationalIDV2"
    PL_PASSPORT_NUMBER: str = "PLPassportNumber"
    PL_TAX_IDENTIFICATION_NUMBER: str = "PLTaxIdentificationNumber"
    PT_CITIZEN_CARD_NUMBER: str = "PTCitizenCardNumber"
    PT_CITIZEN_CARD_NUMBER_V2: str = "PTCitizenCardNumberV2"
    PT_TAX_IDENTIFICATION_NUMBER: str = "PTTaxIdentificationNumber"
    RO_PERSONAL_NUMERICAL_CODE: str = "ROPersonalNumericalCode"
    RU_PASSPORT_NUMBER_DOMESTIC: str = "RUPassportNumberDomestic"
    RU_PASSPORT_NUMBER_INTERNATIONAL: str = "RUPassportNumberInternational"
    SA_NATIONAL_ID: str = "SANationalID"
    SE_NATIONAL_ID: str = "SENationalID"
    SE_NATIONAL_IDV2: str = "SENationalIDV2"
    SE_PASSPORT_NUMBER: str = "SEPassportNumber"
    SE_TAX_IDENTIFICATION_NUMBER: str = "SETaxIdentificationNumber"
    SG_NATIONAL_REGISTRATION_IDENTITY_CARD_NUMBER: str = (
        "SGNationalRegistrationIdentityCardNumber"
    )
    SI_TAX_IDENTIFICATION_NUMBER: str = "SITaxIdentificationNumber"
    SI_UNIQUE_MASTER_CITIZEN_NUMBER: str = "SIUniqueMasterCitizenNumber"
    SK_PERSONAL_NUMBER: str = "SKPersonalNumber"
    SQL_SERVER_CONNECTION_STRING: str = "SQLServerConnectionString"
    SWIFT_CODE: str = "SWIFTCode"
    TH_POPULATION_IDENTIFICATION_CODE: str = "THPopulationIdentificationCode"
    TR_NATIONAL_IDENTIFICATION_NUMBER: str = "TRNationalIdentificationNumber"
    TW_NATIONAL_ID: str = "TWNationalID"
    TW_PASSPORT_NUMBER: str = "TWPassportNumber"
    TW_RESIDENT_CERTIFICATE: str = "TWResidentCertificate"
    UA_PASSPORT_NUMBER_DOMESTIC: str = "UAPassportNumberDomestic"
    UA_PASSPORT_NUMBER_INTERNATIONAL: str = "UAPassportNumberInternational"
    UK_DRIVERS_LICENSE_NUMBER: str = "UKDriversLicenseNumber"
    UK_ELECTORAL_ROLL_NUMBER: str = "UKElectoralRollNumber"
    UK_NATIONAL_HEALTH_NUMBER: str = "UKNationalHealthNumber"
    UK_NATIONAL_INSURANCE_NUMBER: str = "UKNationalInsuranceNumber"
    UK_UNIQUE_TAXPAYER_NUMBER: str = "UKUniqueTaxpayerNumber"
    URL: str = "URL"
    USUK_PASSPORT_NUMBER: str = "USUKPassportNumber"
    US_BANK_ACCOUNT_NUMBER: str = "USBankAccountNumber"
    US_DRIVERS_LICENSE_NUMBER: str = "USDriversLicenseNumber"
    US_INDIVIDUAL_TAXPAYER_IDENTIFICATION: str = "USIndividualTaxpayerIdentification"
    US_SOCIAL_SECURITY_NUMBER: str = "USSocialSecurityNumber"
    ZA_IDENTIFICATION_NUMBER: str = "ZAIdentificationNumber"
    ALL: str = "All"


class AzurePIIType(Enum):
    """
    The values of types returned from the Azure Cognition PII Detection API
    """

    ABA_ROUTING_NUMBER: str = "ABA Routing Number"
    ADDRESS: str = "Address"
    AGE: str = "Age"
    AR_NATIONAL_IDENTITY_NUMBER: str = "AR National Identity Number"
    AT_IDENTITY_CARD: str = "ATIdentityCard"
    AT_TAX_IDENTIFICATION_NUMBER: str = "AT Tax Identification Number"
    AT_VALUE_ADDED_TAX_NUMBER: str = "AT Value Added Tax Number"
    AU_BANK_ACCOUNT_NUMBER: str = "AU Bank Account Number"
    AU_BUSINESS_NUMBER: str = "AU Business Number"
    AU_COMPANY_NUMBER: str = "AU Company Number"
    AU_DRIVERS_LICENSE_NUMBER: str = "AU Drivers License Number"
    AU_MEDICAL_ACCOUNT_NUMBER: str = "AU Medical Account Number"
    AU_PASSPORT_NUMBER: str = "AU Passport Number"
    AU_TAX_FILE_NUMBER: str = "AU Tax File Number"
    AZURE_DOCUMENT_DB_AUTH_KEY: str = "Azure Document DB Auth Key"
    AZURE_IAAS_DATABASE_CONNECTION_AND_SQL_STRING: str = (
        "Azure IAAS Database Connection And SQL String"
    )
    AZURE_IO_T_CONNECTION_STRING: str = "Azure IoT Connection String"
    AZURE_PUBLISH_SETTING_PASSWORD: str = "Azure Publish Setting Password"
    AZURE_REDIS_CACHE_STRING: str = "Azure Redis Cache String"
    AZURE_SAS: str = "Azure SAS"
    AZURE_SERVICE_BUS_STRING: str = "Azure Service Bus String"
    AZURE_STORAGE_ACCOUNT_GENERIC: str = "Azure Storage Account Generic"
    AZURE_STORAGE_ACCOUNT_KEY: str = "Azure Storage Account Key"
    BE_NATIONAL_NUMBER: str = "BE National Number"
    BE_NATIONAL_NUMBER_V2: str = "BE National Number V2"
    BE_VALUE_ADDED_TAX_NUMBER: str = "BE Value Added Tax Number"
    BG_UNIFORM_CIVIL_NUMBER: str = "BG Uniform Civil Number"
    BRCPF_NUMBER: str = "BR CPF Number"
    BR_LEGAL_ENTITY_NUMBER: str = "BR Legal Entity Number"
    BR_NATIONAL_IDRG: str = "BR National IDRG"
    CA_BANK_ACCOUNT_NUMBER: str = "CA Bank Account Number"
    CA_DRIVERS_LICENSE_NUMBER: str = "CA Drivers License Number"
    CA_HEALTH_SERVICE_NUMBER: str = "CA Health Service Number"
    CA_PASSPORT_NUMBER: str = "CA Passport Number"
    CA_PERSONAL_HEALTH_IDENTIFICATION: str = "CA Personal Health Identification"
    CA_SOCIAL_INSURANCE_NUMBER: str = "CA Social Insuranc eNumber"
    CH_SOCIAL_SECURITY_NUMBER: str = "CH Social Security Number"
    CL_IDENTITY_CARD_NUMBER: str = "CL Identity Card Number"
    CN_RESIDENT_IDENTITY_CARD_NUMBER: str = "CN Resident Identity Card Number"
    CREDIT_CARD_NUMBER: str = "Credit Card Number"
    CY_IDENTITY_CARD: str = "CY Identity Card"
    CY_TAX_IDENTIFICATION_NUMBER: str = "CY Tax Identification Number"
    CZ_PERSONAL_IDENTITY_NUMBER: str = "CZ Personal Identity Number"
    CZ_PERSONAL_IDENTITY_V2: str = "CZ Personal Identity V2"
    DATE: str = "Date"
    DEFAULT: str = "Default"
    DE_DRIVERS_LICENSE_NUMBER: str = "DE Drivers License Number"
    DE_IDENTITY_CARD_NUMBER: str = "DE Identity Card Number"
    DE_PASSPORT_NUMBER: str = "DE Passport Number"
    DE_TAX_IDENTIFICATION_NUMBER: str = "DE Tax Identification Number"
    DE_VALUE_ADDED_NUMBER: str = "DE Value Added Number"
    DK_PERSONAL_IDENTIFICATION_NUMBER: str = "DK Personal Identification Number"
    DK_PERSONAL_IDENTIFICATION_V2: str = "DK Personal Identification V2"
    DRUG_ENFORCEMENT_AGENCY_NUMBER: str = "Drug Enforcement Agency Number"
    EE_PERSONAL_IDENTIFICATION_CODE: str = "EE Personal Identification Code"
    EMAIL_ADDRESS: str = "Email"
    ESDNI: str = "ESDNI"
    ES_SOCIAL_SECURITY_NUMBER: str = "ES Social Security Number"
    ES_TAX_IDENTIFICATION_NUMBER: str = "ES Tax Identification Number"
    EUGPS_COORDINATES: str = "EU GPS Coordinates"
    EU_DEBIT_CARD_NUMBER: str = "EU Debit Card Number"
    EU_DRIVERS_LICENSE_NUMBER: str = "EU Drivers License Number"
    EU_NATIONAL_IDENTIFICATION_NUMBER: str = "EU National Identification Number"
    EU_PASSPORT_NUMBER: str = "EU Passport Number"
    EU_SOCIAL_SECURITY_NUMBER: str = "EU Social Security Number"
    EU_TAX_IDENTIFICATION_NUMBER: str = "EU Tax Identification Number"
    FI_EUROPEAN_HEALTH_NUMBER: str = "FI European Health Number"
    FI_NATIONAL_ID: str = "FI National ID"
    FI_NATIONAL_IDV2: str = "FI National IDV2"
    FI_PASSPORT_NUMBER: str = "FI Passport Number"
    FR_DRIVERS_LICENSE_NUMBER: str = "FR Drivers License Number"
    FR_HEALTH_INSURANCE_NUMBER: str = "FR Health Insurance Number"
    FR_NATIONAL_ID: str = "FR National ID"
    FR_PASSPORT_NUMBER: str = "FR Passport Number"
    FR_SOCIAL_SECURITY_NUMBER: str = "FR Social Security Number"
    FR_TAX_IDENTIFICATION_NUMBER: str = "FR Tax Identification Number"
    FR_VALUE_ADDED_TAX_NUMBER: str = "FR Value Added Tax Number"
    GR_NATIONAL_IDV2: str = "GR National ID V2"
    GR_NATIONAL_ID_CARD: str = "GR National ID Card"
    GR_TAX_IDENTIFICATION_NUMBER: str = "GR Tax Identification Number"
    HK_IDENTITY_CARD_NUMBER: str = "HK Identity Card Number"
    HR_IDENTITY_CARD_NUMBER: str = "HR Identity Card Number"
    HR_NATIONAL_ID_NUMBER: str = "HR National ID Number"
    HR_PERSONAL_IDENTIFICATION_NUMBER: str = "HR Personal Identification Number"
    HR_PERSONAL_IDENTIFICATION_OIB_NUMBER_V2: str = (
        "HR Personal Identification OIB Number V2"
    )
    HU_PERSONAL_IDENTIFICATION_NUMBER: str = "HU Personal Identification Number"
    HU_TAX_IDENTIFICATION_NUMBER: str = "HU Tax Identification Number"
    HU_VALUE_ADDED_NUMBER: str = "HU Value Added Number"
    ID_IDENTITY_CARD_NUMBER: str = "ID Identity Card Number"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER: str = "IE Personal Public Service Number"
    IE_PERSONAL_PUBLIC_SERVICE_NUMBER_V2: str = "IE Personal Public Service Number V2"
    IL_BANK_ACCOUNT_NUMBER: str = "IL Bank Account Number"
    IL_NATIONAL_ID: str = "IL National ID"
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER: str = "International Banking Account Number"
    IN_PERMANENT_ACCOUNT: str = "IN Permanent Account"
    IN_UNIQUE_IDENTIFICATION_NUMBER: str = "IN Unique Identification Number"
    IP_ADDRESS: str = "IP Address"
    IT_DRIVERS_LICENSE_NUMBER: str = "IT Drivers License Number"
    IT_FISCAL_CODE: str = "IT Fiscal Code"
    IT_VALUE_ADDED_TAX_NUMBER: str = "IT Value Added Tax Number"
    JP_BANK_ACCOUNT_NUMBER: str = "JP Bank Account Number"
    JP_DRIVERS_LICENSE_NUMBER: str = "JP Drivers License Number"
    JP_MY_NUMBER_CORPORATE: str = "JP MyNumber Corporate"
    JP_MY_NUMBER_PERSONAL: str = "JP MyNumber Personal"
    JP_PASSPORT_NUMBER: str = "JP Passport Number"
    JP_RESIDENCE_CARD_NUMBER: str = "JP Residence Card Number"
    JP_RESIDENT_REGISTRATION_NUMBER: str = "JP Resident Registration Number"
    JP_SOCIAL_INSURANCE_NUMBER: str = "JP Social Insurance Number"
    KR_RESIDENT_REGISTRATION_NUMBER: str = "KR Resident Registration Number"
    LT_PERSONAL_CODE: str = "LT Personal Code"
    LU_NATIONAL_IDENTIFICATION_NUMBER_NATURAL: str = (
        "LU National Identification Number Natural"
    )
    LU_NATIONAL_IDENTIFICATION_NUMBER_NON_NATURAL: str = (
        "LU National Identification Number Non Natural"
    )
    LV_PERSONAL_CODE: str = "LV Personal Code"
    MT_IDENTITY_CARD_NUMBER: str = "MT Identity Card Number"
    MT_TAX_ID_NUMBER: str = "MT Tax ID Number"
    MY_IDENTITY_CARD_NUMBER: str = "MY Identity Card Number"
    NL_CITIZENS_SERVICE_NUMBER: str = "NL Citizens Service Number"
    NL_CITIZENS_SERVICE_NUMBER_V2: str = "NL Citizens Service Number V2"
    NL_TAX_IDENTIFICATION_NUMBER: str = "NL Tax Identification Number"
    NL_VALUE_ADDED_TAX_NUMBER: str = "NL Value Added Tax Number"
    NO_IDENTITY_NUMBER: str = "NO Identity Number"
    NZ_BANK_ACCOUNT_NUMBER: str = "NZ Bank Account Number"
    NZ_DRIVERS_LICENSE_NUMBER: str = "NZ Drivers License Number"
    NZ_INLAND_REVENUE_NUMBER: str = "NZ Inland Revenue Number"
    NZ_MINISTRY_OF_HEALTH_NUMBER: str = "NZ Ministry Of Health Number"
    NZ_SOCIAL_WELFARE_NUMBER: str = "NZ Social Welfare Number"
    ORGANIZATION: str = "Organization"
    PERSON: str = "Person"
    PHONE_NUMBER: str = "Phone Number"
    PH_UNIFIED_MULTI_PURPOSE_ID_NUMBER: str = "PH Unified Multi Purpose ID Number"
    PLREGON_NUMBER: str = "PL REGON Number"
    PL_IDENTITY_CARD: str = "PL Identity Card"
    PL_NATIONAL_ID: str = "PL National ID"
    PL_NATIONAL_IDV2: str = "PL National IDV2"
    PL_PASSPORT_NUMBER: str = "PL Passport Number"
    PL_TAX_IDENTIFICATION_NUMBER: str = "PL Tax Identification Number"
    PT_CITIZEN_CARD_NUMBER: str = "PT Citizen Card Number"
    PT_CITIZEN_CARD_NUMBER_V2: str = "PT Citizen Card Number V2"
    PT_TAX_IDENTIFICATION_NUMBER: str = "PT Tax Identification Number"
    RO_PERSONAL_NUMERICAL_CODE: str = "RO Personal NumericalCode"
    RU_PASSPORT_NUMBER_DOMESTIC: str = "RU Passport Number Domestic"
    RU_PASSPORT_NUMBER_INTERNATIONAL: str = "RU Passport Number International"
    SA_NATIONAL_ID: str = "SA National ID"
    SE_NATIONAL_ID: str = "SE National ID"
    SE_NATIONAL_IDV2: str = "SE National IDV2"
    SE_PASSPORT_NUMBER: str = "SE Passport Number"
    SE_TAX_IDENTIFICATION_NUMBER: str = "SE Tax Identification Number"
    SG_NATIONAL_REGISTRATION_IDENTITY_CARD_NUMBER: str = (
        "SG National Registration Identity Card Number"
    )
    SI_TAX_IDENTIFICATION_NUMBER: str = "SI Tax Identification Number"
    SI_UNIQUE_MASTER_CITIZEN_NUMBER: str = "SI Unique Master Citizen Number"
    SK_PERSONAL_NUMBER: str = "SK Personal Number"
    SQL_SERVER_CONNECTION_STRING: str = "SQL Server Connection String"
    SWIFT_CODE: str = "SWIFT Code"
    TH_POPULATION_IDENTIFICATION_CODE: str = "TH Population Identification Code"
    TR_NATIONAL_IDENTIFICATION_NUMBER: str = "TR National Identification Number"
    TW_NATIONAL_ID: str = "TW National ID"
    TW_PASSPORT_NUMBER: str = "TW Passport Number"
    TW_RESIDENT_CERTIFICATE: str = "TW Resident Certificate"
    UA_PASSPORT_NUMBER_DOMESTIC: str = "UA Passport Number Domestic"
    UA_PASSPORT_NUMBER_INTERNATIONAL: str = "UA Passport Number International"
    UK_DRIVERS_LICENSE_NUMBER: str = "UK Drivers License Number"
    UK_ELECTORAL_ROLL_NUMBER: str = "UK Electoral Roll Number"
    UK_NATIONAL_HEALTH_NUMBER: str = "UK National Health Number"
    UK_NATIONAL_INSURANCE_NUMBER: str = "UK National Insurance Number"
    UK_UNIQUE_TAXPAYER_NUMBER: str = "UK Unique Taxpayer Number"
    URL: str = "URL"
    USUK_PASSPORT_NUMBER: str = "US UK Passport Number"
    US_BANK_ACCOUNT_NUMBER: str = "US Bank Account Number"
    US_DRIVERS_LICENSE_NUMBER: str = "US Drivers License Number"
    US_INDIVIDUAL_TAXPAYER_IDENTIFICATION: str = "US Individual Taxpayer Identification"
    US_SOCIAL_SECURITY_NUMBER: str = "US Social Security Number"
    ZA_IDENTIFICATION_NUMBER: str = "ZA Identification Number"
