"""
This package contains modules for solving semiconductor physics problems.

The modules include functions to calculate different properties of materials
and classes implementing models of materials: intrinsic and doped semiconductors, metals,
p-n junctions and metal-semiconductor junctions, various crystal lattices, etc.
Also, there are instruments to handle unit conversions, since the unit system
used in all computations is cgs (the Gaussian unit system).

A unit of measurement is designated in the description of each class attribute and each parameter or return value of
a function. An occurrence of "[1]" means that the quantity is dimensionless.

More information can be found in the descriptions of the modules.
"""

VERSION = '0.3.0'
