"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClientVpnRoute = exports.ClientVpnRouteTarget = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const ec2_generated_1 = require("./ec2.generated");
/**
 * Target for a client VPN route
 */
class ClientVpnRouteTarget {
    /**
     * Subnet
     *
     * The specified subnet must be an existing target network of the client VPN
     * endpoint.
     */
    static subnet(subnet) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_ISubnet(subnet);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.subnet);
            }
            throw error;
        }
        return { subnetId: subnet.subnetId };
    }
    /**
     * Local network
     */
    static local() {
        return { subnetId: 'local' };
    }
}
exports.ClientVpnRouteTarget = ClientVpnRouteTarget;
_a = JSII_RTTI_SYMBOL_1;
ClientVpnRouteTarget[_a] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRouteTarget", version: "1.158.0" };
/**
 * A client VPN route
 */
class ClientVpnRoute extends core_1.Resource {
    constructor(scope, id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ec2_ClientVpnRouteProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!props.clientVpnEndoint && !props.clientVpnEndpoint) {
            throw new Error('ClientVpnRoute: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified');
        }
        if (props.clientVpnEndoint && props.clientVpnEndpoint) {
            throw new Error('ClientVpnRoute: either clientVpnEndpoint or clientVpnEndoint (deprecated) must be specified' +
                ', but not both');
        }
        const clientVpnEndpoint = props.clientVpnEndoint || props.clientVpnEndpoint;
        super(scope, id);
        const route = new ec2_generated_1.CfnClientVpnRoute(this, 'Resource', {
            clientVpnEndpointId: clientVpnEndpoint.endpointId,
            description: props.description,
            destinationCidrBlock: props.cidr,
            targetVpcSubnetId: props.target.subnetId,
        });
        // See https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-clientvpnroute.html
        route.node.addDependency(clientVpnEndpoint.targetNetworksAssociated);
    }
}
exports.ClientVpnRoute = ClientVpnRoute;
_b = JSII_RTTI_SYMBOL_1;
ClientVpnRoute[_b] = { fqn: "@aws-cdk/aws-ec2.ClientVpnRoute", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xpZW50LXZwbi1yb3V0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsaWVudC12cG4tcm91dGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsd0NBQXlDO0FBR3pDLG1EQUFvRDtBQWdDcEQ7O0dBRUc7QUFDSCxNQUFzQixvQkFBb0I7SUFDeEM7Ozs7O09BS0c7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQWU7Ozs7Ozs7Ozs7UUFDbEMsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7S0FDdEM7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxLQUFLO1FBQ2pCLE9BQU8sRUFBRSxRQUFRLEVBQUUsT0FBTyxFQUFFLENBQUM7S0FDOUI7O0FBaEJILG9EQW9CQzs7O0FBcUJEOztHQUVHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsZUFBUTtJQUMxQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCOzs7Ozs7Ozs7O1FBQ2xFLElBQUksQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLEVBQUU7WUFDdkQsTUFBTSxJQUFJLEtBQUssQ0FDYiw2RkFBNkYsQ0FDOUYsQ0FBQztTQUNIO1FBQ0QsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLElBQUksS0FBSyxDQUFDLGlCQUFpQixFQUFFO1lBQ3JELE1BQU0sSUFBSSxLQUFLLENBQ2IsNkZBQTZGO2dCQUMzRixnQkFBZ0IsQ0FDbkIsQ0FBQztTQUNIO1FBQ0QsTUFBTSxpQkFBaUIsR0FBRyxLQUFLLENBQUMsZ0JBQWdCLElBQUksS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQzVFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxLQUFLLEdBQUcsSUFBSSxpQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BELG1CQUFtQixFQUFFLGlCQUFrQixDQUFDLFVBQVU7WUFDbEQsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxNQUFNLENBQUMsUUFBUTtTQUN6QyxDQUFDLENBQUM7UUFFSCwwR0FBMEc7UUFDMUcsS0FBSyxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsaUJBQWtCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztLQUN2RTs7QUF4Qkgsd0NBeUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUNsaWVudFZwbkVuZHBvaW50IH0gZnJvbSAnLi9jbGllbnQtdnBuLWVuZHBvaW50LXR5cGVzJztcbmltcG9ydCB7IENmbkNsaWVudFZwblJvdXRlIH0gZnJvbSAnLi9lYzIuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElTdWJuZXQgfSBmcm9tICcuL3ZwYyc7XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgYSBDbGllbnRWcG5Sb3V0ZVxuICovXG5leHBvcnQgaW50ZXJmYWNlIENsaWVudFZwblJvdXRlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgSVB2NCBhZGRyZXNzIHJhbmdlLCBpbiBDSURSIG5vdGF0aW9uLCBvZiB0aGUgcm91dGUgZGVzdGluYXRpb24uXG4gICAqXG4gICAqIEZvciBleGFtcGxlOlxuICAgKiAgIC0gVG8gYWRkIGEgcm91dGUgZm9yIEludGVybmV0IGFjY2VzcywgZW50ZXIgMC4wLjAuMC8wXG4gICAqICAgLSBUbyBhZGQgYSByb3V0ZSBmb3IgYSBwZWVyZWQgVlBDLCBlbnRlciB0aGUgcGVlcmVkIFZQQydzIElQdjQgQ0lEUiByYW5nZVxuICAgKiAgIC0gVG8gYWRkIGEgcm91dGUgZm9yIGFuIG9uLXByZW1pc2VzIG5ldHdvcmssIGVudGVyIHRoZSBBV1MgU2l0ZS10by1TaXRlIFZQTlxuICAgKiAgICAgY29ubmVjdGlvbidzIElQdjQgQ0lEUiByYW5nZVxuICAgKiAgIC0gVG8gYWRkIGEgcm91dGUgZm9yIHRoZSBsb2NhbCBuZXR3b3JrLCBlbnRlciB0aGUgY2xpZW50IENJRFIgcmFuZ2VcbiAgICovXG4gIHJlYWRvbmx5IGNpZHI6IHN0cmluZztcblxuICAvKipcbiAgICogQSBicmllZiBkZXNjcmlwdGlvbiBvZiB0aGUgYXV0aG9yaXphdGlvbiBydWxlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGRlc2NyaXB0aW9uXG4gICAqL1xuICByZWFkb25seSBkZXNjcmlwdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIHRhcmdldCBmb3IgdGhlIHJvdXRlXG4gICAqL1xuICByZWFkb25seSB0YXJnZXQ6IENsaWVudFZwblJvdXRlVGFyZ2V0O1xufVxuXG4vKipcbiAqIFRhcmdldCBmb3IgYSBjbGllbnQgVlBOIHJvdXRlXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBDbGllbnRWcG5Sb3V0ZVRhcmdldCB7XG4gIC8qKlxuICAgKiBTdWJuZXRcbiAgICpcbiAgICogVGhlIHNwZWNpZmllZCBzdWJuZXQgbXVzdCBiZSBhbiBleGlzdGluZyB0YXJnZXQgbmV0d29yayBvZiB0aGUgY2xpZW50IFZQTlxuICAgKiBlbmRwb2ludC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgc3VibmV0KHN1Ym5ldDogSVN1Ym5ldCk6IENsaWVudFZwblJvdXRlVGFyZ2V0IHtcbiAgICByZXR1cm4geyBzdWJuZXRJZDogc3VibmV0LnN1Ym5ldElkIH07XG4gIH1cblxuICAvKipcbiAgICogTG9jYWwgbmV0d29ya1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBsb2NhbCgpOiBDbGllbnRWcG5Sb3V0ZVRhcmdldCB7XG4gICAgcmV0dXJuIHsgc3VibmV0SWQ6ICdsb2NhbCcgfTtcbiAgfVxuXG4gIC8qKiBUaGUgc3VibmV0IElEICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBzdWJuZXRJZDogc3RyaW5nO1xufVxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgQ2xpZW50VnBuUm91dGVcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDbGllbnRWcG5Sb3V0ZVByb3BzIGV4dGVuZHMgQ2xpZW50VnBuUm91dGVPcHRpb25zIHtcblxuICAvKipcbiAgICogVGhlIGNsaWVudCBWUE4gZW5kcG9pbnQgdG8gd2hpY2ggdG8gYWRkIHRoZSByb3V0ZS5cbiAgICogQGRlZmF1bHQgY2xpZW50VnBuRW5kcG9pbnQgaXMgcmVxdWlyZWRcbiAgICovXG4gIHJlYWRvbmx5IGNsaWVudFZwbkVuZHBvaW50PzogSUNsaWVudFZwbkVuZHBvaW50O1xuICAvKipcbiAgICogVGhlIGNsaWVudCBWUE4gZW5kcG9pbnQgdG8gd2hpY2ggdG8gYWRkIHRoZSByb3V0ZS5cbiAgICogQGRlcHJlY2F0ZWQgVXNlIGBjbGllbnRWcG5FbmRwb2ludGAgaW5zdGVhZFxuICAgKiBAZGVmYXVsdCBjbGllbnRWcG5FbmRwb2ludCBpcyByZXF1aXJlZFxuXG4gICAqL1xuICByZWFkb25seSBjbGllbnRWcG5FbmRvaW50PzogSUNsaWVudFZwbkVuZHBvaW50O1xufVxuXG4vKipcbiAqIEEgY2xpZW50IFZQTiByb3V0ZVxuICovXG5leHBvcnQgY2xhc3MgQ2xpZW50VnBuUm91dGUgZXh0ZW5kcyBSZXNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDbGllbnRWcG5Sb3V0ZVByb3BzKSB7XG4gICAgaWYgKCFwcm9wcy5jbGllbnRWcG5FbmRvaW50ICYmICFwcm9wcy5jbGllbnRWcG5FbmRwb2ludCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnQ2xpZW50VnBuUm91dGU6IGVpdGhlciBjbGllbnRWcG5FbmRwb2ludCBvciBjbGllbnRWcG5FbmRvaW50IChkZXByZWNhdGVkKSBtdXN0IGJlIHNwZWNpZmllZCcsXG4gICAgICApO1xuICAgIH1cbiAgICBpZiAocHJvcHMuY2xpZW50VnBuRW5kb2ludCAmJiBwcm9wcy5jbGllbnRWcG5FbmRwb2ludCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnQ2xpZW50VnBuUm91dGU6IGVpdGhlciBjbGllbnRWcG5FbmRwb2ludCBvciBjbGllbnRWcG5FbmRvaW50IChkZXByZWNhdGVkKSBtdXN0IGJlIHNwZWNpZmllZCcgK1xuICAgICAgICAgICcsIGJ1dCBub3QgYm90aCcsXG4gICAgICApO1xuICAgIH1cbiAgICBjb25zdCBjbGllbnRWcG5FbmRwb2ludCA9IHByb3BzLmNsaWVudFZwbkVuZG9pbnQgfHwgcHJvcHMuY2xpZW50VnBuRW5kcG9pbnQ7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCByb3V0ZSA9IG5ldyBDZm5DbGllbnRWcG5Sb3V0ZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBjbGllbnRWcG5FbmRwb2ludElkOiBjbGllbnRWcG5FbmRwb2ludCEuZW5kcG9pbnRJZCxcbiAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICAgIGRlc3RpbmF0aW9uQ2lkckJsb2NrOiBwcm9wcy5jaWRyLFxuICAgICAgdGFyZ2V0VnBjU3VibmV0SWQ6IHByb3BzLnRhcmdldC5zdWJuZXRJZCxcbiAgICB9KTtcblxuICAgIC8vIFNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZWMyLWNsaWVudHZwbnJvdXRlLmh0bWxcbiAgICByb3V0ZS5ub2RlLmFkZERlcGVuZGVuY3koY2xpZW50VnBuRW5kcG9pbnQhLnRhcmdldE5ldHdvcmtzQXNzb2NpYXRlZCk7XG4gIH1cbn1cbiJdfQ==