import collections

_MPL_MARKER_DICT = collections.OrderedDict([
    ('circle', 'o'),
    ('x', 'x'),
    ('diamond', 'D'),
    ('plus', '+'),
    ('square', 's'),
    ('point', '.'),
    ('triangle_up', '^'),
    ('tri_left', '3'),
    ('triangle_right', '>'),
    ('thin_diamond', 'd'),
    ('star', '*'),
    ('triangle_down', 'v'),
    ('vline', '|'),
    ('tri_down', '1'),
    ('pentagon', 'p'),
    ('pixel', ','),
    ('tri_up', '2'),
    ('triangle_left', '<'),
    ('hexagon1', 'h'),
    ('tri_right', '4'),
    ('tickleft', 0),
    ('tickup', 2),
    ('tickdown', 3),
    ('caretleft', 4),
    ('hline', '_'),
    ('caretright', 5),
    ('hexagon2', 'H'),
    ('tickright', 1),
    ('caretup', 6),
    ('octagon', '8'),
    ('caretdown', 7)])
_MPL_MARKERS = [*_MPL_MARKER_DICT.values()]

_BOKEH_MARKER_DICT = collections.OrderedDict([
    ('circle', 'circle'),
    ('x', 'x'),
    ('diamond', 'diamond'),
    ('plus', 'cross'),
    ('square', 'square'),
    # ('point', '.'),
    ('triangle_up', 'triangle'),
    # ('tri_left', '3'),
    # ('triangle_right', '>'),
    # ('thin_diamond', 'd'),
    ('star', 'asterisk'),
    ('triangle_down', 'inverted_triangle'),
    # ('vline', '|'),
    # ('tri_down', '1'),
    # ('pentagon', 'p'),
    # ('pixel', ','),
    # ('tri_up', '2'),
    # ('triangle_left', '<'),
    # ('hexagon1', 'h'),
    # ('tri_right', '4'),
    # ('tickleft', 0),
    # ('tickup', 2),
    # ('tickdown', 3),
    # ('caretleft', 4),
    # ('hline', '_'),
    # ('caretright', 5),
    # ('hexagon2', 'H'),
    # ('tickright', 1),
    # ('caretup', 6),
    # ('octagon', '8'),
    # ('caretdown', 7)
    ('circle_cross', 'circle_cross'),
    ('square_x', 'square_x'),
    ('diamond_cross', 'diamond_cross'),
    ('circle_x', 'circle_x'),
    ('square_cross', 'square_cross')])
_BOKEH_MARKERS = [*_BOKEH_MARKER_DICT.values()]

_MARKERS = {'MATPLOTLIB': _MPL_MARKERS, 'BOKEH': _BOKEH_MARKERS}
_SINGLE_LINE_MARKER = {'MATPLOTLIB': ('.',), 'BOKEH': ('circle',)}
