# DustPy

Package for Dust Coagulation and Evolution in Protoplanetary Disks.

## Installation

`pip install dustpy`

## Documentation

[https://stammler.github.io/dustpy/](https://stammler.github.io/dustpy/)


* [1. Basics](https://stammler.github.io/dustpy/1_basics.html)
* [2. Simple Customization](https://stammler.github.io/dustpy/2_simple_customization.html)
* [3. Advanced Customization](https://stammler.github.io/dustpy/3_advanced_customization.html)
* [4. The Standard Model](https://stammler.github.io/dustpy/4_standard_model.html)
* [5. Dust Coagulation](https://stammler.github.io/dustpy/5_dust_coagulation.html)
* [6. Dust Evolution](https://stammler.github.io/dustpy/6_dust_evolution.html)
* [7. Gas Evolution](https://stammler.github.io/dustpy/7_gas_evolution.html)
* [8. Test: Gas Evolution](https://stammler.github.io/dustpy/8_test_gas_evolution.html)

[Module Reference](https://stammler.github.io/dustpy/api.html)

`DustPy` is using the `simframe` framework.  
For details we refer to the [Simframe Documentation](https://simframe.rtfd.io/).

## Ackowledgements

`DustPy` has received funding from the European Research Council (ERC) under the European Union’s Horizon 2020 research and innovation programme under grant agreement No 714769.

`DustPy` was developed at the [University Observatory](https://www.usm.uni-muenchen.de/index_en.php) of the [Ludwig Maximilian University of Munich](https://www.en.uni-muenchen.de/index.html).