/**
 * Information pertaining to an AWS region.
 */
export declare class RegionInfo {
    readonly name: string;
    /**
     * @returns the list of names of AWS regions for which there is at least one registered fact. This
     *          may not be an exaustive list of all available AWS regions.
     */
    static get regions(): RegionInfo[];
    /**
     * Obtain region info for a given region name.
     *
     * @param name the name of the region (e.g: us-east-1)
     */
    static get(name: string): RegionInfo;
    private constructor();
    /**
     * Whether the `AWS::CDK::Metadata` CloudFormation Resource is available in this region or not.
     */
    get cdkMetadataResourceAvailable(): boolean;
    /**
     * The domain name suffix (e.g: amazonaws.com) for this region.
     */
    get domainSuffix(): string | undefined;
    /**
     * The name of the ARN partition for this region (e.g: aws).
     */
    get partition(): string | undefined;
    /**
     * The endpoint used by S3 static website hosting in this region (e.g: s3-static-website-us-east-1.amazonaws.com)
     */
    get s3StaticWebsiteEndpoint(): string | undefined;
    /**
     * The hosted zone ID used by Route 53 to alias a S3 static website in this region (e.g: Z2O1EMRO9K5GLX)
     */
    get s3StaticWebsiteHostedZoneId(): string | undefined;
    /**
     * The prefix for VPC Endpoint Service names,
     * cn.com.amazonaws.vpce for China regions,
     * com.amazonaws.vpce otherwise.
     */
    get vpcEndpointServiceNamePrefix(): string | undefined;
    /**
     * The name of the service principal for a given service in this region.
     * @param service the service name (e.g: s3.amazonaws.com)
     */
    servicePrincipal(service: string): string | undefined;
    /**
     * The account ID for ELBv2 in this region
     *
     */
    get elbv2Account(): string | undefined;
}
