import * as codebuild from "../../../aws-codebuild";
import * as codepipeline from "../../../aws-codepipeline";
import * as events from "../../../aws-events";
import { Construct } from "../../../core";
import { StackOutput } from '../stage';
/**
 * Properties for ShellScriptValidation
 */
export interface ShellScriptActionProps {
    /**
     * Name of the validation action in the pipeline
     */
    readonly actionName: string;
    /**
     * Stack outputs to make available as environment variables
     *
     * @default - No outputs used
     */
    readonly useOutputs?: Record<string, StackOutput>;
    /**
     * Commands to run
     */
    readonly commands: string[];
    /**
     * Bash options to set at the start of the script
     *
     * @default '-eu' (errexit and nounset)
     */
    readonly bashOptions?: string;
    /**
     * Additional artifacts to use as input for the CodeBuild project
     *
     * You can use these files to load more complex test sets into the
     * shellscript build environment.
     *
     * The files artifact given here will be unpacked into the current
     * working directory, the other ones will be unpacked into directories
     * which are available through the environment variables
     * $CODEBUILD_SRC_DIR_<artifactName>.
     *
     * The CodeBuild job must have at least one input artifact, so you
     * must provide either at least one additional artifact here or one
     * stack output using `useOutput`.
     *
     * @default - No additional artifacts
     */
    readonly additionalArtifacts?: codepipeline.Artifact[];
    /**
     * RunOrder for this action
     *
     * Use this to sequence the shell script after the deployments.
     *
     * The default value is 100 so you don't have to supply the value if you just
     * want to run this after the application stacks have been deployed, and you
     * don't have more than 100 stacks.
     *
     * @default 100
     */
    readonly runOrder?: number;
}
/**
 * Validate a revision using shell commands
 */
export declare class ShellScriptAction implements codepipeline.IAction {
    private readonly props;
    private _project?;
    private _action?;
    private _actionProperties;
    constructor(props: ShellScriptActionProps);
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
    /**
     * Exists to implement IAction
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Project generated to run the shell script in
     */
    get project(): codebuild.IProject;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
