"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const path = require("path");
function appOf(construct) {
    const root = construct.node.root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${construct.node.path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    var _a;
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = (_a = core_1.Stage.of(scope)) !== null && _a !== void 0 ? _a : appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
//# sourceMappingURL=data:application/json;base64,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