import * as codepipeline from "../../../aws-codepipeline";
import * as events from "../../../aws-events";
import { Construct } from "../../../core";
/**
 * Props for the UpdatePipelineAction
 */
export interface UpdatePipelineActionProps {
    /**
     * The CodePipeline artifact that holds the Cloud Assembly.
     */
    readonly cloudAssemblyInput: codepipeline.Artifact;
    /**
     * Name of the pipeline stack
     */
    readonly pipelineStackName: string;
    /**
     * Version of CDK CLI to 'npm install'.
     *
     * @default - Latest version
     */
    readonly cdkCliVersion?: string;
    /**
     * Name of the CodeBuild project
     *
     * @default - Automatically generated
     */
    readonly projectName?: string;
}
/**
 * Action to self-mutate the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 */
export declare class UpdatePipelineAction extends Construct implements codepipeline.IAction {
    private readonly action;
    constructor(scope: Construct, id: string, props: UpdatePipelineActionProps);
    /**
     * Exists to implement IAction
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
}
