"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcSubnetGroupType = void 0;
/**
 * The type of subnet group.
 * Same as SubnetType in the @aws-cdk/aws-ec2 package,
 * but we can't use that because of cyclical dependencies.
 */
var VpcSubnetGroupType;
(function (VpcSubnetGroupType) {
    /** Public subnet group type. */
    VpcSubnetGroupType["PUBLIC"] = "Public";
    /** Private subnet group type. */
    VpcSubnetGroupType["PRIVATE"] = "Private";
    /** Isolated subnet group type. */
    VpcSubnetGroupType["ISOLATED"] = "Isolated";
})(VpcSubnetGroupType = exports.VpcSubnetGroupType || (exports.VpcSubnetGroupType = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidnBjLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidnBjLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBOzs7O0dBSUc7QUFDSCxJQUFZLGtCQU9YO0FBUEQsV0FBWSxrQkFBa0I7SUFDMUIsZ0NBQWdDO0lBQ2hDLHVDQUFpQixDQUFBO0lBQ2pCLGlDQUFpQztJQUNqQyx5Q0FBbUIsQ0FBQTtJQUNuQixrQ0FBa0M7SUFDbEMsMkNBQXFCLENBQUE7QUFDekIsQ0FBQyxFQVBXLGtCQUFrQixHQUFsQiwwQkFBa0IsS0FBbEIsMEJBQWtCLFFBTzdCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBUaGUgdHlwZSBvZiBzdWJuZXQgZ3JvdXAuXG4gKiBTYW1lIGFzIFN1Ym5ldFR5cGUgaW4gdGhlIEBhd3MtY2RrL2F3cy1lYzIgcGFja2FnZSxcbiAqIGJ1dCB3ZSBjYW4ndCB1c2UgdGhhdCBiZWNhdXNlIG9mIGN5Y2xpY2FsIGRlcGVuZGVuY2llcy5cbiAqL1xuZXhwb3J0IGVudW0gVnBjU3VibmV0R3JvdXBUeXBlIHtcbiAgICAvKiogUHVibGljIHN1Ym5ldCBncm91cCB0eXBlLiAqL1xuICAgIFBVQkxJQyA9ICdQdWJsaWMnLFxuICAgIC8qKiBQcml2YXRlIHN1Ym5ldCBncm91cCB0eXBlLiAqL1xuICAgIFBSSVZBVEUgPSAnUHJpdmF0ZScsXG4gICAgLyoqIElzb2xhdGVkIHN1Ym5ldCBncm91cCB0eXBlLiAqL1xuICAgIElTT0xBVEVEID0gJ0lzb2xhdGVkJ1xufVxuLyoqXG4gKiBBIHN1Ym5ldCByZXByZXNlbnRhdGlvbiB0aGF0IHRoZSBWUEMgcHJvdmlkZXIgdXNlcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBWcGNTdWJuZXQge1xuICAgIC8qKiBUaGUgaWRlbnRpZmllciBvZiB0aGUgc3VibmV0LiAqL1xuICAgIHJlYWRvbmx5IHN1Ym5ldElkOiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogVGhlIGNvZGUgb2YgdGhlIGF2YWlsYWJpbGl0eSB6b25lIHRoaXMgc3VibmV0IGlzIGluXG4gICAgICogKGZvciBleGFtcGxlLCAndXMtd2VzdC0yYScpLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGF2YWlsYWJpbGl0eVpvbmU6IHN0cmluZztcbiAgICAvKiogVGhlIGlkZW50aWZpZXIgb2YgdGhlIHJvdXRlIHRhYmxlIGZvciB0aGlzIHN1Ym5ldC4gKi9cbiAgICByZWFkb25seSByb3V0ZVRhYmxlSWQ6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBDSURSIHJhbmdlIG9mIHRoZSBzdWJuZXRcbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IC0gQ0lEUiBpbmZvcm1hdGlvbiBub3QgYXZhaWxhYmxlXG4gICAgICovXG4gICAgcmVhZG9ubHkgY2lkcj86IHN0cmluZztcbn1cbi8qKlxuICogQSBncm91cCBvZiBzdWJuZXRzIHJldHVybmVkIGJ5IHRoZSBWUEMgcHJvdmlkZXIuXG4gKiBUaGUgaW5jbHVkZWQgc3VibmV0cyBkbyBOT1QgaGF2ZSB0byBiZSBzeW1tZXRyaWMhXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVnBjU3VibmV0R3JvdXAge1xuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSBzdWJuZXQgZ3JvdXAsXG4gICAgICogZGV0ZXJtaW5lZCBieSBsb29raW5nIGF0IHRoZSB0YWdzIG9mIG9mIHRoZSBzdWJuZXRzXG4gICAgICogdGhhdCBiZWxvbmcgdG8gaXQuXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICAgIC8qKiBUaGUgdHlwZSBvZiB0aGUgc3VibmV0IGdyb3VwLiAqL1xuICAgIHJlYWRvbmx5IHR5cGU6IFZwY1N1Ym5ldEdyb3VwVHlwZTtcbiAgICAvKipcbiAgICAgKiBUaGUgc3VibmV0cyB0aGF0IGFyZSBwYXJ0IG9mIHRoaXMgZ3JvdXAuXG4gICAgICogVGhlcmUgaXMgbm8gY29uZGl0aW9uIHRoYXQgdGhlIHN1Ym5ldHMgaGF2ZSB0byBiZSBzeW1tZXRyaWNcbiAgICAgKiBpbiB0aGUgZ3JvdXAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgc3VibmV0czogVnBjU3VibmV0W107XG59XG4vKipcbiAqIFByb3BlcnRpZXMgb2YgYSBkaXNjb3ZlcmVkIFZQQ1xuICovXG5leHBvcnQgaW50ZXJmYWNlIFZwY0NvbnRleHRSZXNwb25zZSB7XG4gICAgLyoqXG4gICAgICogVlBDIGlkXG4gICAgICovXG4gICAgcmVhZG9ubHkgdnBjSWQ6IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBWUEMgY2lkclxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBDSURSIGluZm9ybWF0aW9uIG5vdCBhdmFpbGFibGVcbiAgICAgKi9cbiAgICByZWFkb25seSB2cGNDaWRyQmxvY2s/OiBzdHJpbmc7XG4gICAgLyoqXG4gICAgICogQVpzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYXZhaWxhYmlsaXR5Wm9uZXM6IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIElEcyBvZiBhbGwgcHVibGljIHN1Ym5ldHNcbiAgICAgKlxuICAgICAqIEVsZW1lbnQgY291bnQ6ICMoYXZhaWxhYmlsaXR5Wm9uZXMpIMK3ICMocHVibGljR3JvdXBzKVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHB1YmxpY1N1Ym5ldElkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIE5hbWUgb2YgcHVibGljIHN1Ym5ldCBncm91cHNcbiAgICAgKlxuICAgICAqIEVsZW1lbnQgY291bnQ6ICMocHVibGljR3JvdXBzKVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHB1YmxpY1N1Ym5ldE5hbWVzPzogc3RyaW5nW107XG4gICAgLyoqXG4gICAgICogUm91dGUgVGFibGUgSURzIG9mIHB1YmxpYyBzdWJuZXQgZ3JvdXBzLlxuICAgICAqXG4gICAgICogRWxlbWVudCBjb3VudDogIyhhdmFpbGFiaWxpdHlab25lcykgwrcgIyhwdWJsaWNHcm91cHMpXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHVibGljU3VibmV0Um91dGVUYWJsZUlkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIElEcyBvZiBhbGwgcHJpdmF0ZSBzdWJuZXRzXG4gICAgICpcbiAgICAgKiBFbGVtZW50IGNvdW50OiAjKGF2YWlsYWJpbGl0eVpvbmVzKSDCtyAjKHByaXZhdGVHcm91cHMpXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpdmF0ZVN1Ym5ldElkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIE5hbWUgb2YgcHJpdmF0ZSBzdWJuZXQgZ3JvdXBzXG4gICAgICpcbiAgICAgKiBFbGVtZW50IGNvdW50OiAjKHByaXZhdGVHcm91cHMpXG4gICAgICovXG4gICAgcmVhZG9ubHkgcHJpdmF0ZVN1Ym5ldE5hbWVzPzogc3RyaW5nW107XG4gICAgLyoqXG4gICAgICogUm91dGUgVGFibGUgSURzIG9mIHByaXZhdGUgc3VibmV0IGdyb3Vwcy5cbiAgICAgKlxuICAgICAqIEVsZW1lbnQgY291bnQ6ICMoYXZhaWxhYmlsaXR5Wm9uZXMpIMK3ICMocHJpdmF0ZUdyb3VwcylcbiAgICAgKi9cbiAgICByZWFkb25seSBwcml2YXRlU3VibmV0Um91dGVUYWJsZUlkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIElEcyBvZiBhbGwgaXNvbGF0ZWQgc3VibmV0c1xuICAgICAqXG4gICAgICogRWxlbWVudCBjb3VudDogIyhhdmFpbGFiaWxpdHlab25lcykgwrcgIyhpc29sYXRlZEdyb3VwcylcbiAgICAgKi9cbiAgICByZWFkb25seSBpc29sYXRlZFN1Ym5ldElkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIE5hbWUgb2YgaXNvbGF0ZWQgc3VibmV0IGdyb3Vwc1xuICAgICAqXG4gICAgICogRWxlbWVudCBjb3VudDogIyhpc29sYXRlZEdyb3VwcylcbiAgICAgKi9cbiAgICByZWFkb25seSBpc29sYXRlZFN1Ym5ldE5hbWVzPzogc3RyaW5nW107XG4gICAgLyoqXG4gICAgICogUm91dGUgVGFibGUgSURzIG9mIGlzb2xhdGVkIHN1Ym5ldCBncm91cHMuXG4gICAgICpcbiAgICAgKiBFbGVtZW50IGNvdW50OiAjKGF2YWlsYWJpbGl0eVpvbmVzKSDCtyAjKGlzb2xhdGVkR3JvdXBzKVxuICAgICAqL1xuICAgIHJlYWRvbmx5IGlzb2xhdGVkU3VibmV0Um91dGVUYWJsZUlkcz86IHN0cmluZ1tdO1xuICAgIC8qKlxuICAgICAqIFRoZSBWUE4gZ2F0ZXdheSBJRFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHZwbkdhdGV3YXlJZD86IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgc3VibmV0IGdyb3VwcyBkaXNjb3ZlcmVkIGZvciB0aGUgZ2l2ZW4gVlBDLlxuICAgICAqIFVubGlrZSB0aGUgYWJvdmUgcHJvcGVydGllcywgdGhpcyB3aWxsIGluY2x1ZGUgYXN5bW1ldHJpYyBzdWJuZXRzLFxuICAgICAqIGlmIHRoZSBWUEMgaGFzIGFueS5cbiAgICAgKiBUaGlzIHByb3BlcnR5IHdpbGwgb25seSBiZSBwb3B1bGF0ZWQgaWYge0BsaW5rIFZwY0NvbnRleHRRdWVyeS5yZXR1cm5Bc3ltbWV0cmljU3VibmV0c31cbiAgICAgKiBpcyB0cnVlLlxuICAgICAqXG4gICAgICogQGRlZmF1bHQgLSBubyBzdWJuZXQgZ3JvdXBzIHdpbGwgYmUgcmV0dXJuZWQgdW5sZXNzIHtAbGluayBWcGNDb250ZXh0UXVlcnkucmV0dXJuQXN5bW1ldHJpY1N1Ym5ldHN9IGlzIHRydWVcbiAgICAgKi9cbiAgICByZWFkb25seSBzdWJuZXRHcm91cHM/OiBWcGNTdWJuZXRHcm91cFtdO1xufVxuIl19