"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeInspector = void 0;
/**
 * Inspector that maintains an attribute bag
 */
class TreeInspector {
    constructor() {
        /**
         * Represents the bag of attributes as key-value pairs.
         */
        this.attributes = {};
    }
    /**
     * Adds attribute to bag. Keys should be added by convention to prevent conflicts
     * i.e. L1 constructs will contain attributes with keys prefixed with aws:cdk:cloudformation
     *
     * @param key - key for metadata
     * @param value - value of metadata.
     */
    addAttribute(key, value) {
        this.attributes[key] = value;
    }
}
exports.TreeInspector = TreeInspector;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJlZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyZWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUE7O0dBRUc7QUFDSCxNQUFhLGFBQWE7SUFBMUI7UUFDSTs7V0FFRztRQUNhLGVBQVUsR0FFdEIsRUFBRSxDQUFDO0lBV1gsQ0FBQztJQVZHOzs7Ozs7T0FNRztJQUNJLFlBQVksQ0FBQyxHQUFXLEVBQUUsS0FBVTtRQUN2QyxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEtBQUssQ0FBQztJQUNqQyxDQUFDO0NBQ0o7QUFqQkQsc0NBaUJDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBJbnNwZWN0b3IgdGhhdCBtYWludGFpbnMgYW4gYXR0cmlidXRlIGJhZ1xuICovXG5leHBvcnQgY2xhc3MgVHJlZUluc3BlY3RvciB7XG4gICAgLyoqXG4gICAgICogUmVwcmVzZW50cyB0aGUgYmFnIG9mIGF0dHJpYnV0ZXMgYXMga2V5LXZhbHVlIHBhaXJzLlxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyaWJ1dGVzOiB7XG4gICAgICAgIFtrZXk6IHN0cmluZ106IGFueTtcbiAgICB9ID0ge307XG4gICAgLyoqXG4gICAgICogQWRkcyBhdHRyaWJ1dGUgdG8gYmFnLiBLZXlzIHNob3VsZCBiZSBhZGRlZCBieSBjb252ZW50aW9uIHRvIHByZXZlbnQgY29uZmxpY3RzXG4gICAgICogaS5lLiBMMSBjb25zdHJ1Y3RzIHdpbGwgY29udGFpbiBhdHRyaWJ1dGVzIHdpdGgga2V5cyBwcmVmaXhlZCB3aXRoIGF3czpjZGs6Y2xvdWRmb3JtYXRpb25cbiAgICAgKlxuICAgICAqIEBwYXJhbSBrZXkgLSBrZXkgZm9yIG1ldGFkYXRhXG4gICAgICogQHBhcmFtIHZhbHVlIC0gdmFsdWUgb2YgbWV0YWRhdGEuXG4gICAgICovXG4gICAgcHVibGljIGFkZEF0dHJpYnV0ZShrZXk6IHN0cmluZywgdmFsdWU6IGFueSkge1xuICAgICAgICB0aGlzLmF0dHJpYnV0ZXNba2V5XSA9IHZhbHVlO1xuICAgIH1cbn1cbi8qKlxuICogSW50ZXJmYWNlIGZvciBleGFtaW5pbmcgYSBjb25zdHJ1Y3QgYW5kIGV4cG9zaW5nIG1ldGFkYXRhLlxuICpcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIGNvbnN0cnVjdFxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqL1xuICAgIGluc3BlY3QoaW5zcGVjdG9yOiBUcmVlSW5zcGVjdG9yKTogdm9pZDtcbn1cbiJdfQ==