"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveTag = exports.Tag = void 0;
const tag_manager_1 = require("./tag-manager");
/**
 * The common functionality for Tag and Remove Tag Aspects
 */
class TagBase {
    constructor(key, props = {}) {
        this.key = key;
        this.props = props;
    }
    visit(construct) {
        if (tag_manager_1.TagManager.isTaggable(construct)) {
            this.applyTag(construct);
        }
    }
}
/**
 * The Tag Aspect will handle adding a tag to this node and cascading tags to children
 */
class Tag extends TagBase {
    constructor(key, value, props = {}) {
        super(key, props);
        this.defaultPriority = 100;
        if (value === undefined) {
            throw new Error('Tag must have a value');
        }
        this.value = value;
    }
    /**
     * add tags to the node of a construct and all its the taggable children
     */
    static add(scope, key, value, props = {}) {
        scope.node.applyAspect(new Tag(key, value, props));
    }
    /**
     * remove tags to the node of a construct and all its the taggable children
     */
    static remove(scope, key, props = {}) {
        scope.node.applyAspect(new RemoveTag(key, props));
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.setTag(this.key, this.value, this.props.priority !== undefined ? this.props.priority : this.defaultPriority, this.props.applyToLaunchedInstances !== false);
        }
    }
}
exports.Tag = Tag;
/**
 * The RemoveTag Aspect will handle removing tags from this node and children
 */
class RemoveTag extends TagBase {
    constructor(key, props = {}) {
        super(key, props);
        this.defaultPriority = 200;
    }
    applyTag(resource) {
        if (resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes)) {
            resource.tags.removeTag(this.key, this.props.priority !== undefined ? this.props.priority : this.defaultPriority);
        }
    }
}
exports.RemoveTag = RemoveTag;
//# sourceMappingURL=data:application/json;base64,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