"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reference = void 0;
const intrinsic_1 = require("./private/intrinsic");
const REFERENCE_SYMBOL = Symbol.for('@aws-cdk/core.Reference');
/**
 * An intrinsic Token that represents a reference to a construct.
 *
 * References are recorded.
 */
class Reference extends intrinsic_1.Intrinsic {
    constructor(value, target, displayName) {
        super(value);
        Object.defineProperty(this, REFERENCE_SYMBOL, { value: true });
        this.target = target;
        this.displayName = displayName || 'Reference';
    }
    /**
     * Check whether this is actually a Reference
     */
    static isReference(x) {
        return typeof x === 'object' && x !== null && REFERENCE_SYMBOL in x;
    }
}
exports.Reference = Reference;
//# sourceMappingURL=data:application/json;base64,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