"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyDirectory = void 0;
const fs = require("fs");
const path = require("path");
const options_1 = require("./options");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    const follow = options.follow !== undefined ? options.follow : options_1.SymlinkFollowMode.EXTERNAL;
    const exclude = options.exclude || [];
    rootDir = rootDir || srcDir;
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (utils_1.shouldExclude(exclude, path.relative(rootDir, sourceFilePath))) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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