"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDynamicReferenceService = exports.CfnDynamicReference = void 0;
const intrinsic_1 = require("./private/intrinsic");
/**
 * References a dynamically retrieved value
 *
 * This is a Construct so that subclasses will (eventually) be able to attach
 * metadata to themselves without having to change call signatures.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
 */
class CfnDynamicReference extends intrinsic_1.Intrinsic {
    constructor(service, key) {
        super('{{resolve:' + service + ':' + key + '}}');
    }
}
exports.CfnDynamicReference = CfnDynamicReference;
/**
 * The service to retrieve the dynamic reference from
 */
var CfnDynamicReferenceService;
(function (CfnDynamicReferenceService) {
    /**
     * Plaintext value stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM"] = "ssm";
    /**
     * Secure string stored in AWS Systems Manager Parameter Store
     */
    CfnDynamicReferenceService["SSM_SECURE"] = "ssm-secure";
    /**
     * Secret stored in AWS Secrets Manager
     */
    CfnDynamicReferenceService["SECRETS_MANAGER"] = "secretsmanager";
})(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
//# sourceMappingURL=data:application/json;base64,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