"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmrModifyInstanceGroupByName = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const cdk = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const task_utils_1 = require("../private/task-utils");
const cluster_utils_1 = require("./private/cluster-utils");
/**
 * A Step Functions Task to to modify an InstanceGroup on an EMR Cluster.
 *
 * @experimental
 */
class EmrModifyInstanceGroupByName extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['elasticmapreduce:ModifyInstanceGroups', 'elasticmapreduce:ListInstanceGroups'],
                resources: [`arn:aws:elasticmapreduce:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:cluster/*`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('elasticmapreduce', 'modifyInstanceGroupByName', sfn.IntegrationPattern.REQUEST_RESPONSE),
            Parameters: sfn.FieldUtils.renderObject({
                ClusterId: this.props.clusterId,
                InstanceGroupName: this.props.instanceGroupName,
                InstanceGroup: cluster_utils_1.InstanceGroupModifyConfigPropertyToJson(this.props.instanceGroup),
            }),
        };
    }
}
exports.EmrModifyInstanceGroupByName = EmrModifyInstanceGroupByName;
//# sourceMappingURL=data:application/json;base64,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