"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoGetItem = void 0;
const iam = require("../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const sfn = require("../../../aws-stepfunctions"); // Automatically re-written from '@aws-cdk/aws-stepfunctions'
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const utils_1 = require("./private/utils");
/**
 * A StepFunctions task to call DynamoGetItem
 */
class DynamoGetItem extends sfn.TaskStateBase {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.props = props;
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [
                    core_1.Stack.of(this).formatArn({
                        service: 'dynamodb',
                        resource: 'table',
                        resourceName: props.table.tableName,
                    }),
                ],
                actions: [`dynamodb:${utils_1.DynamoMethod.GET}Item`],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        var _a;
        return {
            Resource: utils_1.getDynamoResourceArn(utils_1.DynamoMethod.GET),
            Parameters: sfn.FieldUtils.renderObject({
                Key: utils_1.transformAttributeValueMap(this.props.key),
                TableName: this.props.table.tableName,
                ConsistentRead: (_a = this.props.consistentRead) !== null && _a !== void 0 ? _a : false,
                ExpressionAttributeNames: this.props.expressionAttributeNames,
                ProjectionExpression: this.configureProjectionExpression(this.props.projectionExpression),
                ReturnConsumedCapacity: this.props.returnConsumedCapacity,
            }),
        };
    }
    configureProjectionExpression(expressions) {
        return expressions ? expressions.map((expression) => expression.toString()).join(',') : undefined;
    }
}
exports.DynamoGetItem = DynamoGetItem;
//# sourceMappingURL=data:application/json;base64,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