"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright 2012-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cloudwatch = require("../../aws-cloudwatch"); // Automatically re-written from '@aws-cdk/aws-cloudwatch'
const topic_base_1 = require("./topic-base");
topic_base_1.TopicBase.prototype.metric = function (metricName, props) {
    return new cloudwatch.Metric({
        namespace: 'AWS/SNS',
        metricName,
        dimensions: { TopicName: this.topicName },
        ...props
    }).attachTo(this);
};
topic_base_1.TopicBase.prototype.metricPublishSize = function (props) {
    return this.metric('PublishSize', { statistic: 'Average', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfMessagesPublished = function (props) {
    return this.metric('NumberOfMessagesPublished', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsDelivered = function (props) {
    return this.metric('NumberOfNotificationsDelivered', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFailed = function (props) {
    return this.metric('NumberOfNotificationsFailed', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOut = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutNoMessageAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-NoMessageAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricNumberOfNotificationsFilteredOutInvalidAttributes = function (props) {
    return this.metric('NumberOfNotificationsFilteredOut-InvalidAttributes', { statistic: 'Sum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSMonthToDateSpentUSD = function (props) {
    return this.metric('SMSMonthToDateSpentUSD', { statistic: 'Maximum', ...props });
};
topic_base_1.TopicBase.prototype.metricSMSSuccessRate = function (props) {
    return this.metric('SMSSuccessRate', { statistic: 'Sum', ...props });
};
//# sourceMappingURL=data:application/json;base64,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