import { PolicyDocument } from "../../aws-iam";
import { Construct, Resource } from "../../core";
import { ITopic } from './topic-base';
/**
 * Properties to associate SNS topics with a policy
 */
export interface TopicPolicyProps {
    /**
     * The set of topics this policy applies to.
     */
    readonly topics: ITopic[];
}
/**
 * Applies a policy to SNS topics.
 */
export declare class TopicPolicy extends Resource {
    /**
     * The IAM policy document for this policy.
     */
    readonly document: PolicyDocument;
    constructor(scope: Construct, id: string, props: TopicPolicyProps);
}
