import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::SageMaker::CodeRepository`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export interface CfnCodeRepositoryProps {
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    readonly gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    readonly codeRepositoryName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::CodeRepository`
 *
 * @cloudformationResource AWS::SageMaker::CodeRepository
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html
 */
export declare class CfnCodeRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::CodeRepository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCodeRepository;
    /**
     * @cloudformationAttribute CodeRepositoryName
     */
    readonly attrCodeRepositoryName: string;
    /**
     * `AWS::SageMaker::CodeRepository.GitConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-gitconfig
     */
    gitConfig: CfnCodeRepository.GitConfigProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::CodeRepository.CodeRepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-coderepository.html#cfn-sagemaker-coderepository-coderepositoryname
     */
    codeRepositoryName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::CodeRepository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCodeRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCodeRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html
     */
    interface GitConfigProperty {
        /**
         * `CfnCodeRepository.GitConfigProperty.Branch`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-branch
         */
        readonly branch?: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.RepositoryUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-repositoryurl
         */
        readonly repositoryUrl: string;
        /**
         * `CfnCodeRepository.GitConfigProperty.SecretArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-coderepository-gitconfig.html#cfn-sagemaker-coderepository-gitconfig-secretarn
         */
        readonly secretArn?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Endpoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export interface CfnEndpointProps {
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    readonly endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    readonly endpointName?: string;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    readonly excludeRetainedVariantProperties?: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    readonly retainAllVariantProperties?: boolean | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::Endpoint`
 *
 * @cloudformationResource AWS::SageMaker::Endpoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @cloudformationAttribute EndpointName
     */
    readonly attrEndpointName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointconfigname
     */
    endpointConfigName: string;
    /**
     * `AWS::SageMaker::Endpoint.EndpointName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-endpointname
     */
    endpointName: string | undefined;
    /**
     * `AWS::SageMaker::Endpoint.ExcludeRetainedVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-excluderetainedvariantproperties
     */
    excludeRetainedVariantProperties: Array<CfnEndpoint.VariantPropertyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.RetainAllVariantProperties`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-retainallvariantproperties
     */
    retainAllVariantProperties: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpoint.html#cfn-sagemaker-endpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html
     */
    interface VariantPropertyProperty {
        /**
         * `CfnEndpoint.VariantPropertyProperty.VariantPropertyType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpoint-variantproperty.html#cfn-sagemaker-endpoint-variantproperty-variantpropertytype
         */
        readonly variantPropertyType?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::EndpointConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export interface CfnEndpointConfigProps {
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    readonly productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    readonly endpointConfigName?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::SageMaker::EndpointConfig`
 *
 * @cloudformationResource AWS::SageMaker::EndpointConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html
 */
export declare class CfnEndpointConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::EndpointConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnEndpointConfig;
    /**
     * @cloudformationAttribute EndpointConfigName
     */
    readonly attrEndpointConfigName: string;
    /**
     * `AWS::SageMaker::EndpointConfig.ProductionVariants`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-productionvariants
     */
    productionVariants: Array<CfnEndpointConfig.ProductionVariantProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::EndpointConfig.EndpointConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-endpointconfigname
     */
    endpointConfigName: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::EndpointConfig.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-endpointconfig.html#cfn-sagemaker-endpointconfig-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SageMaker::EndpointConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEndpointConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html
     */
    interface ProductionVariantProperty {
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.AcceleratorType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-acceleratortype
         */
        readonly acceleratorType?: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialInstanceCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialinstancecount
         */
        readonly initialInstanceCount: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InitialVariantWeight`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-initialvariantweight
         */
        readonly initialVariantWeight: number;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.InstanceType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-instancetype
         */
        readonly instanceType: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.ModelName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-modelname
         */
        readonly modelName: string;
        /**
         * `CfnEndpointConfig.ProductionVariantProperty.VariantName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-endpointconfig-productionvariant.html#cfn-sagemaker-endpointconfig-productionvariant-variantname
         */
        readonly variantName: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Model`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export interface CfnModelProps {
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    readonly executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    readonly containers?: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.ModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    readonly modelName?: string;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    readonly primaryContainer?: CfnModel.ContainerDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Model.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Model.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    readonly vpcConfig?: CfnModel.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::Model`
 *
 * @cloudformationResource AWS::SageMaker::Model
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html
 */
export declare class CfnModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Model";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnModel;
    /**
     * @cloudformationAttribute ModelName
     */
    readonly attrModelName: string;
    /**
     * `AWS::SageMaker::Model.ExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-executionrolearn
     */
    executionRoleArn: string;
    /**
     * `AWS::SageMaker::Model.Containers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-containers
     */
    containers: Array<CfnModel.ContainerDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.ModelName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-modelname
     */
    modelName: string | undefined;
    /**
     * `AWS::SageMaker::Model.PrimaryContainer`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-primarycontainer
     */
    primaryContainer: CfnModel.ContainerDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Model.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Model.VpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-model.html#cfn-sagemaker-model-vpcconfig
     */
    vpcConfig: CfnModel.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::Model`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnModelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html
     */
    interface ContainerDefinitionProperty {
        /**
         * `CfnModel.ContainerDefinitionProperty.ContainerHostname`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-containerhostname
         */
        readonly containerHostname?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Environment`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-environment
         */
        readonly environment?: any | cdk.IResolvable;
        /**
         * `CfnModel.ContainerDefinitionProperty.Image`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-image
         */
        readonly image: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.Mode`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-mode
         */
        readonly mode?: string;
        /**
         * `CfnModel.ContainerDefinitionProperty.ModelDataUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-containerdefinition.html#cfn-sagemaker-model-containerdefinition-modeldataurl
         */
        readonly modelDataUrl?: string;
    }
}
export declare namespace CfnModel {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html
     */
    interface VpcConfigProperty {
        /**
         * `CfnModel.VpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnModel.VpcConfigProperty.Subnets`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-model-vpcconfig.html#cfn-sagemaker-model-vpcconfig-subnets
         */
        readonly subnets: string[];
    }
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export interface CfnNotebookInstanceProps {
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    readonly acceleratorTypes?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    readonly additionalCodeRepositories?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    readonly defaultCodeRepository?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    readonly directInternetAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    readonly lifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    readonly notebookInstanceName?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    readonly rootAccess?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    readonly securityGroupIds?: string[];
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    readonly subnetId?: string;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    readonly volumeSizeInGb?: number;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstance`
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html
 */
export declare class CfnNotebookInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnNotebookInstance;
    /**
     * @cloudformationAttribute NotebookInstanceName
     */
    readonly attrNotebookInstanceName: string;
    /**
     * `AWS::SageMaker::NotebookInstance.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-instancetype
     */
    instanceType: string;
    /**
     * `AWS::SageMaker::NotebookInstance.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rolearn
     */
    roleArn: string;
    /**
     * `AWS::SageMaker::NotebookInstance.AcceleratorTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-acceleratortypes
     */
    acceleratorTypes: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.AdditionalCodeRepositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-additionalcoderepositories
     */
    additionalCodeRepositories: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DefaultCodeRepository`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-defaultcoderepository
     */
    defaultCodeRepository: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.DirectInternetAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-directinternetaccess
     */
    directInternetAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.LifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-lifecycleconfigname
     */
    lifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.NotebookInstanceName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-notebookinstancename
     */
    notebookInstanceName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.RootAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-rootaccess
     */
    rootAccess: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-securitygroupids
     */
    securityGroupIds: string[] | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-subnetid
     */
    subnetId: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::NotebookInstance.VolumeSizeInGB`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstance.html#cfn-sagemaker-notebookinstance-volumesizeingb
     */
    volumeSizeInGb: number | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNotebookInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SageMaker::NotebookInstanceLifecycleConfig`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export interface CfnNotebookInstanceLifecycleConfigProps {
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    readonly notebookInstanceLifecycleConfigName?: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    readonly onCreate?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    readonly onStart?: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SageMaker::NotebookInstanceLifecycleConfig`
 *
 * @cloudformationResource AWS::SageMaker::NotebookInstanceLifecycleConfig
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html
 */
export declare class CfnNotebookInstanceLifecycleConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::NotebookInstanceLifecycleConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnNotebookInstanceLifecycleConfig;
    /**
     * @cloudformationAttribute NotebookInstanceLifecycleConfigName
     */
    readonly attrNotebookInstanceLifecycleConfigName: string;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.NotebookInstanceLifecycleConfigName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecycleconfigname
     */
    notebookInstanceLifecycleConfigName: string | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnCreate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-oncreate
     */
    onCreate: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::NotebookInstanceLifecycleConfig.OnStart`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-notebookinstancelifecycleconfig.html#cfn-sagemaker-notebookinstancelifecycleconfig-onstart
     */
    onStart: Array<CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SageMaker::NotebookInstanceLifecycleConfig`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnNotebookInstanceLifecycleConfigProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNotebookInstanceLifecycleConfig {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html
     */
    interface NotebookInstanceLifecycleHookProperty {
        /**
         * `CfnNotebookInstanceLifecycleConfig.NotebookInstanceLifecycleHookProperty.Content`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook.html#cfn-sagemaker-notebookinstancelifecycleconfig-notebookinstancelifecyclehook-content
         */
        readonly content?: string;
    }
}
/**
 * Properties for defining a `AWS::SageMaker::Workteam`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export interface CfnWorkteamProps {
    /**
     * `AWS::SageMaker::Workteam.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    readonly description?: string;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    readonly memberDefinitions?: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    readonly notificationConfiguration?: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::SageMaker::Workteam.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    readonly workteamName?: string;
}
/**
 * A CloudFormation `AWS::SageMaker::Workteam`
 *
 * @cloudformationResource AWS::SageMaker::Workteam
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html
 */
export declare class CfnWorkteam extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SageMaker::Workteam";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnWorkteam;
    /**
     * @cloudformationAttribute WorkteamName
     */
    readonly attrWorkteamName: string;
    /**
     * `AWS::SageMaker::Workteam.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-description
     */
    description: string | undefined;
    /**
     * `AWS::SageMaker::Workteam.MemberDefinitions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-memberdefinitions
     */
    memberDefinitions: Array<CfnWorkteam.MemberDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.NotificationConfiguration`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-notificationconfiguration
     */
    notificationConfiguration: CfnWorkteam.NotificationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::SageMaker::Workteam.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SageMaker::Workteam.WorkteamName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-workteam.html#cfn-sagemaker-workteam-workteamname
     */
    workteamName: string | undefined;
    /**
     * Create a new `AWS::SageMaker::Workteam`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWorkteamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html
     */
    interface CognitoMemberDefinitionProperty {
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoClientId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitoclientid
         */
        readonly cognitoClientId: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitousergroup
         */
        readonly cognitoUserGroup: string;
        /**
         * `CfnWorkteam.CognitoMemberDefinitionProperty.CognitoUserPool`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-cognitomemberdefinition.html#cfn-sagemaker-workteam-cognitomemberdefinition-cognitouserpool
         */
        readonly cognitoUserPool: string;
    }
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html
     */
    interface MemberDefinitionProperty {
        /**
         * `CfnWorkteam.MemberDefinitionProperty.CognitoMemberDefinition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-memberdefinition.html#cfn-sagemaker-workteam-memberdefinition-cognitomemberdefinition
         */
        readonly cognitoMemberDefinition: CfnWorkteam.CognitoMemberDefinitionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnWorkteam {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html
     */
    interface NotificationConfigurationProperty {
        /**
         * `CfnWorkteam.NotificationConfigurationProperty.NotificationTopicArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-workteam-notificationconfiguration.html#cfn-sagemaker-workteam-notificationconfiguration-notificationtopicarn
         */
        readonly notificationTopicArn: string;
    }
}
