"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBucketName = exports.parseBucketArn = void 0;
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return cdk.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName,
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return cdk.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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