"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target
 */
class UserPoolDomainTarget {
    constructor(domain) {
        this.domain = domain;
    }
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.CLOUDFRONT_ZONE_ID,
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUVBLDJEQUF1RDtBQUN2RDs7R0FFRztBQUNILE1BQWEsb0JBQW9CO0lBQzdCLFlBQTZCLE1BQXNCO1FBQXRCLFdBQU0sR0FBTixNQUFNLENBQWdCO0lBQ25ELENBQUM7SUFDTSxJQUFJLENBQUMsT0FBbUI7UUFDM0IsT0FBTztZQUNILE9BQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQjtZQUN6QyxZQUFZLEVBQUUsb0NBQWdCLENBQUMsa0JBQWtCO1NBQ3BELENBQUM7SUFDTixDQUFDO0NBQ0o7QUFURCxvREFTQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFVzZXJQb29sRG9tYWluIH0gZnJvbSBcIi4uLy4uL2F3cy1jb2duaXRvXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtY29nbml0bydcbmltcG9ydCB7IEFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnLCBJQWxpYXNSZWNvcmRUYXJnZXQsIElSZWNvcmRTZXQgfSBmcm9tIFwiLi4vLi4vYXdzLXJvdXRlNTNcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJ1xuaW1wb3J0IHsgQ2xvdWRGcm9udFRhcmdldCB9IGZyb20gJy4vY2xvdWRmcm9udC10YXJnZXQnO1xuLyoqXG4gKiBVc2UgYSB1c2VyIHBvb2wgZG9tYWluIGFzIGFuIGFsaWFzIHJlY29yZCB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIFVzZXJQb29sRG9tYWluVGFyZ2V0IGltcGxlbWVudHMgSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRvbWFpbjogVXNlclBvb2xEb21haW4pIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3JlY29yZDogSVJlY29yZFNldCk6IEFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGRuc05hbWU6IHRoaXMuZG9tYWluLmNsb3VkRnJvbnREb21haW5OYW1lLFxuICAgICAgICAgICAgaG9zdGVkWm9uZUlkOiBDbG91ZEZyb250VGFyZ2V0LkNMT1VERlJPTlRfWk9ORV9JRCxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=