"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontTarget = void 0;
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    bind(_record) {
        return {
            hostedZoneId: CloudFrontTarget.CLOUDFRONT_ZONE_ID,
            dnsName: this.distribution.domainName,
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
CloudFrontTarget.CLOUDFRONT_ZONE_ID = 'Z2FDTNDATAQYW2';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmcm9udC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZyb250LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFFQTs7R0FFRztBQUNILE1BQWEsZ0JBQWdCO0lBTXpCLFlBQTZCLFlBQWtEO1FBQWxELGlCQUFZLEdBQVosWUFBWSxDQUFzQztJQUMvRSxDQUFDO0lBQ00sSUFBSSxDQUFDLE9BQTJCO1FBQ25DLE9BQU87WUFDSCxZQUFZLEVBQUUsZ0JBQWdCLENBQUMsa0JBQWtCO1lBQ2pELE9BQU8sRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLFVBQVU7U0FDeEMsQ0FBQztJQUNOLENBQUM7O0FBYkwsNENBY0M7QUFiRzs7O0dBR0c7QUFDb0IsbUNBQWtCLEdBQUcsZ0JBQWdCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjbG91ZGZyb250IGZyb20gXCIuLi8uLi9hd3MtY2xvdWRmcm9udFwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnXG5pbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gXCIuLi8uLi9hd3Mtcm91dGU1M1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnXG4vKipcbiAqIFVzZSBhIENsb3VkRnJvbnQgRGlzdHJpYnV0aW9uIGFzIGFuIGFsaWFzIHJlY29yZCB0YXJnZXRcbiAqL1xuZXhwb3J0IGNsYXNzIENsb3VkRnJvbnRUYXJnZXQgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gICAgLyoqXG4gICAgICogVGhlIGhvc3RlZCB6b25lIElkIGlmIHVzaW5nIGFuIGFsaWFzIHJlY29yZCBpbiBSb3V0ZTUzLlxuICAgICAqIFRoaXMgdmFsdWUgbmV2ZXIgY2hhbmdlcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENMT1VERlJPTlRfWk9ORV9JRCA9ICdaMkZEVE5EQVRBUVlXMic7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkaXN0cmlidXRpb246IGNsb3VkZnJvbnQuQ2xvdWRGcm9udFdlYkRpc3RyaWJ1dGlvbikge1xuICAgIH1cbiAgICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGhvc3RlZFpvbmVJZDogQ2xvdWRGcm9udFRhcmdldC5DTE9VREZST05UX1pPTkVfSUQsXG4gICAgICAgICAgICBkbnNOYW1lOiB0aGlzLmRpc3RyaWJ1dGlvbi5kb21haW5OYW1lLFxuICAgICAgICB9O1xuICAgIH1cbn1cbiJdfQ==