"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = exports.ApiGatewayDomain = void 0;
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
    }
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        if (!api.domainName) {
            throw new Error('API does not define a default domain name');
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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