import { ICertificate } from "../../aws-certificatemanager";
import { IHostedZone } from "../../aws-route53";
import { Construct } from "../../core";
/**
 * Properties to configure an HTTPS Redirect
 */
export interface HttpsRedirectProps {
    /**
     * HostedZone of the domain
     */
    readonly zone: IHostedZone;
    /**
     * The redirect target domain
     */
    readonly targetDomain: string;
    /**
     * The domain names to create that will redirect to `targetDomain`
     *
     * @default - the domain name of the zone
     */
    readonly recordNames?: string[];
    /**
     * The ACM certificate; Has to be in us-east-1
     *
     * @default - create a new certificate in us-east-1
     */
    readonly certificate?: ICertificate;
}
/**
 * Allows creating a domainA -> domainB redirect using CloudFront and S3.
 * You can specify multiple domains to be redirected.
 */
export declare class HttpsRedirect extends Construct {
    constructor(scope: Construct, id: string, props: HttpsRedirectProps);
}
