"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Endpoint = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Connection endpoint of a redshift cluster
 *
 * Consists of a combination of hostname and port.
 */
class Endpoint {
    constructor(address, port) {
        this.hostname = address;
        this.port = port;
        const portDesc = core_1.Token.isUnresolved(port) ? core_1.Token.asString(port) : port;
        this.socketAddress = `${address}:${portDesc}`;
    }
}
exports.Endpoint = Endpoint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW5kcG9pbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJlbmRwb2ludC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBbUMsQ0FBQyxnREFBZ0Q7QUFDcEY7Ozs7R0FJRztBQUNILE1BQWEsUUFBUTtJQWFqQixZQUFZLE9BQWUsRUFBRSxJQUFZO1FBQ3JDLElBQUksQ0FBQyxRQUFRLEdBQUcsT0FBTyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLE1BQU0sUUFBUSxHQUFHLFlBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUN4RSxJQUFJLENBQUMsYUFBYSxHQUFHLEdBQUcsT0FBTyxJQUFJLFFBQVEsRUFBRSxDQUFDO0lBQ2xELENBQUM7Q0FDSjtBQW5CRCw0QkFtQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUb2tlbiB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBDb25uZWN0aW9uIGVuZHBvaW50IG9mIGEgcmVkc2hpZnQgY2x1c3RlclxuICpcbiAqIENvbnNpc3RzIG9mIGEgY29tYmluYXRpb24gb2YgaG9zdG5hbWUgYW5kIHBvcnQuXG4gKi9cbmV4cG9ydCBjbGFzcyBFbmRwb2ludCB7XG4gICAgLyoqXG4gICAgICogVGhlIGhvc3RuYW1lIG9mIHRoZSBlbmRwb2ludFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBob3N0bmFtZTogc3RyaW5nO1xuICAgIC8qKlxuICAgICAqIFRoZSBwb3J0IG9mIHRoZSBlbmRwb2ludFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBwb3J0OiBudW1iZXI7XG4gICAgLyoqXG4gICAgICogVGhlIGNvbWJpbmF0aW9uIG9mIFwiSE9TVE5BTUU6UE9SVFwiIGZvciB0aGlzIGVuZHBvaW50XG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IHNvY2tldEFkZHJlc3M6IHN0cmluZztcbiAgICBjb25zdHJ1Y3RvcihhZGRyZXNzOiBzdHJpbmcsIHBvcnQ6IG51bWJlcikge1xuICAgICAgICB0aGlzLmhvc3RuYW1lID0gYWRkcmVzcztcbiAgICAgICAgdGhpcy5wb3J0ID0gcG9ydDtcbiAgICAgICAgY29uc3QgcG9ydERlc2MgPSBUb2tlbi5pc1VucmVzb2x2ZWQocG9ydCkgPyBUb2tlbi5hc1N0cmluZyhwb3J0KSA6IHBvcnQ7XG4gICAgICAgIHRoaXMuc29ja2V0QWRkcmVzcyA9IGAke2FkZHJlc3N9OiR7cG9ydERlc2N9YDtcbiAgICB9XG59XG4iXX0=