"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscriptionFilter = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const logs_generated_1 = require("./logs.generated");
/**
 * A new Subscription on a CloudWatch log group.
 */
class SubscriptionFilter extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const destProps = props.destination.bind(this, props.logGroup);
        new logs_generated_1.CfnSubscriptionFilter(this, 'Resource', {
            logGroupName: props.logGroup.logGroupName,
            destinationArn: destProps.arn,
            roleArn: destProps.role && destProps.role.roleArn,
            filterPattern: props.filterPattern.logPatternString,
        });
    }
}
exports.SubscriptionFilter = SubscriptionFilter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3Vic2NyaXB0aW9uLWZpbHRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN1YnNjcmlwdGlvbi1maWx0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0EscUNBQWlELENBQUMsZ0RBQWdEO0FBRWxHLHFEQUF5RDtBQXlDekQ7O0dBRUc7QUFDSCxNQUFhLGtCQUFtQixTQUFRLGVBQVE7SUFDNUMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE4QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLE1BQU0sU0FBUyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDL0QsSUFBSSxzQ0FBcUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3hDLFlBQVksRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFlBQVk7WUFDekMsY0FBYyxFQUFFLFNBQVMsQ0FBQyxHQUFHO1lBQzdCLE9BQU8sRUFBRSxTQUFTLENBQUMsSUFBSSxJQUFJLFNBQVMsQ0FBQyxJQUFJLENBQUMsT0FBTztZQUNqRCxhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0I7U0FDdEQsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztDQUNKO0FBWEQsZ0RBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSBcIi4uLy4uL2F3cy1pYW1cIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nXG5pbXBvcnQgeyBDb25zdHJ1Y3QsIFJlc291cmNlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBJTG9nR3JvdXAsIFN1YnNjcmlwdGlvbkZpbHRlck9wdGlvbnMgfSBmcm9tICcuL2xvZy1ncm91cCc7XG5pbXBvcnQgeyBDZm5TdWJzY3JpcHRpb25GaWx0ZXIgfSBmcm9tICcuL2xvZ3MuZ2VuZXJhdGVkJztcbi8qKlxuICogSW50ZXJmYWNlIGZvciBjbGFzc2VzIHRoYXQgY2FuIGJlIHRoZSBkZXN0aW5hdGlvbiBvZiBhIGxvZyBTdWJzY3JpcHRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTG9nU3Vic2NyaXB0aW9uRGVzdGluYXRpb24ge1xuICAgIC8qKlxuICAgICAqIFJldHVybiB0aGUgcHJvcGVydGllcyByZXF1aXJlZCB0byBzZW5kIHN1YnNjcmlwdGlvbiBldmVudHMgdG8gdGhpcyBkZXN0aW5hdGlvbi5cbiAgICAgKlxuICAgICAqIElmIG5lY2Vzc2FyeSwgdGhlIGRlc3RpbmF0aW9uIGNhbiB1c2UgdGhlIHByb3BlcnRpZXMgb2YgdGhlIFN1YnNjcmlwdGlvbkZpbHRlclxuICAgICAqIG9iamVjdCBpdHNlbGYgdG8gY29uZmlndXJlIGl0cyBwZXJtaXNzaW9ucyB0byBhbGxvdyB0aGUgc3Vic2NyaXB0aW9uIHRvIHdyaXRlXG4gICAgICogdG8gaXQuXG4gICAgICpcbiAgICAgKiBUaGUgZGVzdGluYXRpb24gbWF5IHJlY29uZmlndXJlIGl0cyBvd24gcGVybWlzc2lvbnMgaW4gcmVzcG9uc2UgdG8gdGhpc1xuICAgICAqIGZ1bmN0aW9uIGNhbGwuXG4gICAgICovXG4gICAgYmluZChzY29wZTogQ29uc3RydWN0LCBzb3VyY2VMb2dHcm91cDogSUxvZ0dyb3VwKTogTG9nU3Vic2NyaXB0aW9uRGVzdGluYXRpb25Db25maWc7XG59XG4vKipcbiAqIFByb3BlcnRpZXMgcmV0dXJuZWQgYnkgYSBTdWJzY3JpcHRpb24gZGVzdGluYXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBMb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgLyoqXG4gICAgICogVGhlIEFSTiBvZiB0aGUgc3Vic2NyaXB0aW9uJ3MgZGVzdGluYXRpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBhcm46IHN0cmluZztcbiAgICAvKipcbiAgICAgKiBUaGUgcm9sZSB0byBhc3N1bWUgdG8gd3JpdGUgbG9nIGV2ZW50cyB0byB0aGUgZGVzdGluYXRpb25cbiAgICAgKlxuICAgICAqIEBkZWZhdWx0IE5vIHJvbGUgYXNzdW1lZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJvbGU/OiBpYW0uSVJvbGU7XG59XG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGEgU3Vic2NyaXB0aW9uRmlsdGVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU3Vic2NyaXB0aW9uRmlsdGVyUHJvcHMgZXh0ZW5kcyBTdWJzY3JpcHRpb25GaWx0ZXJPcHRpb25zIHtcbiAgICAvKipcbiAgICAgKiBUaGUgbG9nIGdyb3VwIHRvIGNyZWF0ZSB0aGUgc3Vic2NyaXB0aW9uIG9uLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IGxvZ0dyb3VwOiBJTG9nR3JvdXA7XG59XG4vKipcbiAqIEEgbmV3IFN1YnNjcmlwdGlvbiBvbiBhIENsb3VkV2F0Y2ggbG9nIGdyb3VwLlxuICovXG5leHBvcnQgY2xhc3MgU3Vic2NyaXB0aW9uRmlsdGVyIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdWJzY3JpcHRpb25GaWx0ZXJQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICBjb25zdCBkZXN0UHJvcHMgPSBwcm9wcy5kZXN0aW5hdGlvbi5iaW5kKHRoaXMsIHByb3BzLmxvZ0dyb3VwKTtcbiAgICAgICAgbmV3IENmblN1YnNjcmlwdGlvbkZpbHRlcih0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBsb2dHcm91cE5hbWU6IHByb3BzLmxvZ0dyb3VwLmxvZ0dyb3VwTmFtZSxcbiAgICAgICAgICAgIGRlc3RpbmF0aW9uQXJuOiBkZXN0UHJvcHMuYXJuLFxuICAgICAgICAgICAgcm9sZUFybjogZGVzdFByb3BzLnJvbGUgJiYgZGVzdFByb3BzLnJvbGUucm9sZUFybixcbiAgICAgICAgICAgIGZpbHRlclBhdHRlcm46IHByb3BzLmZpbHRlclBhdHRlcm4ubG9nUGF0dGVyblN0cmluZyxcbiAgICAgICAgfSk7XG4gICAgfVxufVxuIl19