"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Construct {
    constructor(scope, id, role) {
        super(scope, id);
        this.role = role;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
        // do nothing
    }
    addManagedPolicy(_policy) {
        // do nothing
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // Not really added, but for the purposes of consumer code pretend that it was.
        return { statementAdded: true, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1tdXRhYmxlLXJvbGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbW11dGFibGUtcm9sZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSx3Q0FBK0UsQ0FBQyxnREFBZ0Q7QUFPaEk7Ozs7Ozs7Ozs7OztHQVlHO0FBQ0gsTUFBYSxhQUFjLFNBQVEsZ0JBQVM7SUFPeEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBbUIsSUFBVztRQUNsRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRHNDLFNBQUksR0FBSixJQUFJLENBQU87UUFOdEQscUJBQWdCLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUM5QyxtQkFBYyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1FBQzFDLG1CQUFjLEdBQUcsSUFBSSxDQUFDO1FBQ3RCLFlBQU8sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUM1QixhQUFRLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7UUFDOUIsVUFBSyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBR3BDLGtDQUFrQztRQUNsQyxzQkFBZSxDQUFDLFNBQVMsQ0FBQyxJQUFJLEVBQUU7WUFDNUIsZUFBZSxFQUFFLENBQUMsSUFBSSxDQUFDO1NBQzFCLENBQUMsQ0FBQztJQUNQLENBQUM7SUFDTSxrQkFBa0IsQ0FBQyxPQUFlO1FBQ3JDLGFBQWE7SUFDakIsQ0FBQztJQUNNLGdCQUFnQixDQUFDLE9BQXVCO1FBQzNDLGFBQWE7SUFDakIsQ0FBQztJQUNNLFdBQVcsQ0FBQyxTQUEwQjtRQUN6QyxPQUFPLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxTQUFTLENBQUMsQ0FBQyxjQUFjLENBQUM7SUFDL0QsQ0FBQztJQUNNLG9CQUFvQixDQUFDLFVBQTJCO1FBQ25ELCtFQUErRTtRQUMvRSxPQUFPLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxnQkFBZ0IsRUFBRSxJQUFJLHlCQUFrQixFQUFFLEVBQUUsQ0FBQztJQUNoRixDQUFDO0lBQ00sS0FBSyxDQUFDLE9BQW1CLEVBQUUsR0FBRyxPQUFpQjtRQUNsRCxPQUFPLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sRUFBRSxHQUFHLE9BQU8sQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDTSxhQUFhLENBQUMsT0FBbUI7UUFDcEMsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUM1QyxDQUFDO0NBQ0o7QUFqQ0Qsc0NBaUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uY3JldGVEZXBlbmRhYmxlLCBDb25zdHJ1Y3QsIERlcGVuZGFibGVUcmFpdCB9IGZyb20gXCIuLi8uLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuaW1wb3J0IHsgR3JhbnQgfSBmcm9tICcuLi9ncmFudCc7XG5pbXBvcnQgeyBJTWFuYWdlZFBvbGljeSB9IGZyb20gJy4uL21hbmFnZWQtcG9saWN5JztcbmltcG9ydCB7IFBvbGljeSB9IGZyb20gJy4uL3BvbGljeSc7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tICcuLi9wb2xpY3ktc3RhdGVtZW50JztcbmltcG9ydCB7IEFkZFRvUHJpbmNpcGFsUG9saWN5UmVzdWx0LCBJUHJpbmNpcGFsIH0gZnJvbSAnLi4vcHJpbmNpcGFscyc7XG5pbXBvcnQgeyBJUm9sZSB9IGZyb20gJy4uL3JvbGUnO1xuLyoqXG4gKiBBbiBpbW11dGFibGUgd3JhcHBlciBhcm91bmQgYW4gSVJvbGVcbiAqXG4gKiBUaGlzIHdyYXBwZXIgaWdub3JlcyBhbGwgbXV0YXRpbmcgb3BlcmF0aW9ucywgbGlrZSBhdHRhY2hpbmcgcG9saWNpZXMgb3JcbiAqIGFkZGluZyBwb2xpY3kgc3RhdGVtZW50cy5cbiAqXG4gKiBVc2VmdWwgaW4gY2FzZXMgd2hlcmUgeW91IHdhbnQgdG8gdHVybiBvZmYgQ0RLJ3MgYXV0b21hdGljIHBlcm1pc3Npb25zXG4gKiBtYW5hZ2VtZW50LCBhbmQgaW5zdGVhZCBoYXZlIGZ1bGwgY29udHJvbCBvdmVyIGFsbCBwZXJtaXNzaW9ucy5cbiAqXG4gKiBOb3RlOiBpZiB5b3Ugd2FudCB0byBpZ25vcmUgYWxsIG11dGF0aW9ucyBmb3IgYW4gZXh0ZXJuYWxseSBkZWZpbmVkIHJvbGVcbiAqIHdoaWNoIHdhcyBpbXBvcnRlZCBpbnRvIHRoZSBDREsgd2l0aCB7QGxpbmsgUm9sZS5mcm9tUm9sZUFybn0sIHlvdSBkb24ndCBoYXZlIHRvIHVzZSB0aGlzIGNsYXNzIC1cbiAqIHNpbXBseSBwYXNzIHRoZSBwcm9wZXJ0eSBtdXRhYmxlID0gZmFsc2Ugd2hlbiBjYWxsaW5nIHtAbGluayBSb2xlLmZyb21Sb2xlQXJufS5cbiAqL1xuZXhwb3J0IGNsYXNzIEltbXV0YWJsZVJvbGUgZXh0ZW5kcyBDb25zdHJ1Y3QgaW1wbGVtZW50cyBJUm9sZSB7XG4gICAgcHVibGljIHJlYWRvbmx5IGFzc3VtZVJvbGVBY3Rpb24gPSB0aGlzLnJvbGUuYXNzdW1lUm9sZUFjdGlvbjtcbiAgICBwdWJsaWMgcmVhZG9ubHkgcG9saWN5RnJhZ21lbnQgPSB0aGlzLnJvbGUucG9saWN5RnJhZ21lbnQ7XG4gICAgcHVibGljIHJlYWRvbmx5IGdyYW50UHJpbmNpcGFsID0gdGhpcztcbiAgICBwdWJsaWMgcmVhZG9ubHkgcm9sZUFybiA9IHRoaXMucm9sZS5yb2xlQXJuO1xuICAgIHB1YmxpYyByZWFkb25seSByb2xlTmFtZSA9IHRoaXMucm9sZS5yb2xlTmFtZTtcbiAgICBwdWJsaWMgcmVhZG9ubHkgc3RhY2sgPSB0aGlzLnJvbGUuc3RhY2s7XG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJpdmF0ZSByZWFkb25seSByb2xlOiBJUm9sZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuICAgICAgICAvLyBpbXBsZW1lbnQgSURlcGVuZGFibGUgcHJpdmF0ZWx5XG4gICAgICAgIERlcGVuZGFibGVUcmFpdC5pbXBsZW1lbnQodGhpcywge1xuICAgICAgICAgICAgZGVwZW5kZW5jeVJvb3RzOiBbcm9sZV0sXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICBwdWJsaWMgYXR0YWNoSW5saW5lUG9saWN5KF9wb2xpY3k6IFBvbGljeSk6IHZvaWQge1xuICAgICAgICAvLyBkbyBub3RoaW5nXG4gICAgfVxuICAgIHB1YmxpYyBhZGRNYW5hZ2VkUG9saWN5KF9wb2xpY3k6IElNYW5hZ2VkUG9saWN5KTogdm9pZCB7XG4gICAgICAgIC8vIGRvIG5vdGhpbmdcbiAgICB9XG4gICAgcHVibGljIGFkZFRvUG9saWN5KHN0YXRlbWVudDogUG9saWN5U3RhdGVtZW50KTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiB0aGlzLmFkZFRvUHJpbmNpcGFsUG9saWN5KHN0YXRlbWVudCkuc3RhdGVtZW50QWRkZWQ7XG4gICAgfVxuICAgIHB1YmxpYyBhZGRUb1ByaW5jaXBhbFBvbGljeShfc3RhdGVtZW50OiBQb2xpY3lTdGF0ZW1lbnQpOiBBZGRUb1ByaW5jaXBhbFBvbGljeVJlc3VsdCB7XG4gICAgICAgIC8vIE5vdCByZWFsbHkgYWRkZWQsIGJ1dCBmb3IgdGhlIHB1cnBvc2VzIG9mIGNvbnN1bWVyIGNvZGUgcHJldGVuZCB0aGF0IGl0IHdhcy5cbiAgICAgICAgcmV0dXJuIHsgc3RhdGVtZW50QWRkZWQ6IHRydWUsIHBvbGljeURlcGVuZGFibGU6IG5ldyBDb25jcmV0ZURlcGVuZGFibGUoKSB9O1xuICAgIH1cbiAgICBwdWJsaWMgZ3JhbnQoZ3JhbnRlZTogSVByaW5jaXBhbCwgLi4uYWN0aW9uczogc3RyaW5nW10pOiBHcmFudCB7XG4gICAgICAgIHJldHVybiB0aGlzLnJvbGUuZ3JhbnQoZ3JhbnRlZSwgLi4uYWN0aW9ucyk7XG4gICAgfVxuICAgIHB1YmxpYyBncmFudFBhc3NSb2xlKGdyYW50ZWU6IElQcmluY2lwYWwpOiBHcmFudCB7XG4gICAgICAgIHJldHVybiB0aGlzLnJvbGUuZ3JhbnRQYXNzUm9sZShncmFudGVlKTtcbiAgICB9XG59XG4iXX0=