"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
/**
 * Enum for representing all the days of the week
 */
var Weekday;
(function (Weekday) {
    /**
     * Sunday
     */
    Weekday["SUNDAY"] = "0";
    /**
     * Monday
     */
    Weekday["MONDAY"] = "1";
    /**
     * Tuesday
     */
    Weekday["TUESDAY"] = "2";
    /**
     * Wednesday
     */
    Weekday["WEDNESDAY"] = "3";
    /**
     * Thursday
     */
    Weekday["THURSDAY"] = "4";
    /**
     * Friday
     */
    Weekday["FRIDAY"] = "5";
    /**
     * Saturday
     */
    Weekday["SATURDAY"] = "6";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 */
class LustreMaintenanceTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
//# sourceMappingURL=data:application/json;base64,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