"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunction = void 0;
const util_1 = require("./util");
/**
 * Use an AWS Lambda function as an event rule target.
 */
class LambdaFunction {
    constructor(handler, props = {}) {
        this.handler = handler;
        this.props = props;
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Lambda as a
     * result from an EventBridge event.
     */
    bind(rule, _id) {
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, this.handler);
        return {
            id: '',
            arn: this.handler.functionArn,
            input: this.props.event,
            targetResource: this.handler,
        };
    }
}
exports.LambdaFunction = LambdaFunction;
//# sourceMappingURL=data:application/json;base64,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