import * as cdk from "../../../core";
import { BaseTargetGroupProps, ITargetGroup, LoadBalancerTargetProps, TargetGroupAttributes, TargetGroupBase, TargetGroupImportProps } from '../shared/base-target-group';
import { Protocol } from '../shared/enums';
import { INetworkListener } from './network-listener';
/**
 * Properties for a new Network Target Group
 */
export interface NetworkTargetGroupProps extends BaseTargetGroupProps {
    /**
     * The port on which the listener listens for requests.
     */
    readonly port: number;
    /**
     * Protocol for target group, expects TCP, TLS, UDP, or TCP_UDP.
     *
     * @default - TCP
     */
    readonly protocol?: Protocol;
    /**
     * Indicates whether Proxy Protocol version 2 is enabled.
     *
     * @default false
     */
    readonly proxyProtocolV2?: boolean;
    /**
     * The targets to add to this target group.
     *
     * Can be `Instance`, `IPAddress`, or any self-registering load balancing
     * target. If you use either `Instance` or `IPAddress` as targets, all
     * target must be of the same type.
     *
     * @default - No targets.
     */
    readonly targets?: INetworkLoadBalancerTarget[];
}
/**
 * Define a Network Target Group
 */
export declare class NetworkTargetGroup extends TargetGroupBase implements INetworkTargetGroup {
    /**
     * Import an existing target group
     */
    static fromTargetGroupAttributes(scope: cdk.Construct, id: string, attrs: TargetGroupAttributes): INetworkTargetGroup;
    /**
     * Import an existing listener
     *
     * @deprecated Use `fromTargetGroupAttributes` instead
     */
    static import(scope: cdk.Construct, id: string, props: TargetGroupImportProps): INetworkTargetGroup;
    private readonly listeners;
    constructor(scope: cdk.Construct, id: string, props: NetworkTargetGroupProps);
    /**
     * Add a load balancing target to this target group
     */
    addTarget(...targets: INetworkLoadBalancerTarget[]): void;
    /**
     * Register a listener that is load balancing to this target group.
     *
     * Don't call this directly. It will be called by listeners.
     */
    registerListener(listener: INetworkListener): void;
    /**
     * Full name of first load balancer
     */
    get firstLoadBalancerFullName(): string;
    protected validate(): string[];
}
/**
 * A network target group
 */
export interface INetworkTargetGroup extends ITargetGroup {
    /**
     * Register a listener that is load balancing to this target group.
     *
     * Don't call this directly. It will be called by listeners.
     */
    registerListener(listener: INetworkListener): void;
    /**
     * Add a load balancing target to this target group
     */
    addTarget(...targets: INetworkLoadBalancerTarget[]): void;
}
/**
 * Interface for constructs that can be targets of an network load balancer
 */
export interface INetworkLoadBalancerTarget {
    /**
     * Attach load-balanced target to a TargetGroup
     *
     * May return JSON to directly add to the [Targets] list, or return undefined
     * if the target will register itself with the load balancer.
     */
    attachToNetworkTargetGroup(targetGroup: INetworkTargetGroup): LoadBalancerTargetProps;
}
