"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const crypto = require("crypto");
const KUBECTL_APP_ARN = 'arn:aws:serverlessrepo:us-east-1:903779448426:applications/lambda-layer-kubectl';
const KUBECTL_APP_CN_ARN = 'arn:aws-cn:serverlessrepo:cn-north-1:487369736442:applications/lambda-layer-kubectl';
const KUBECTL_APP_VERSION = '1.13.7';
/**
 * An AWS Lambda layer that includes kubectl and the AWS CLI.
 *
 * @see https://github.com/aws-samples/aws-lambda-layer-kubectl
 */
class KubectlLayer extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * All runtimes are compatible.
         */
        this.compatibleRuntimes = undefined;
        const uniqueId = crypto.createHash('md5').update(this.node.path).digest('hex');
        const version = props.version || KUBECTL_APP_VERSION;
        this.stack.templateOptions.transforms = ['AWS::Serverless-2016-10-31']; // required for AWS::Serverless
        const resource = new core_1.CfnResource(this, 'Resource', {
            type: 'AWS::Serverless::Application',
            properties: {
                Location: {
                    ApplicationId: this.isChina() ? KUBECTL_APP_CN_ARN : KUBECTL_APP_ARN,
                    SemanticVersion: version,
                },
                Parameters: {
                    LayerName: `kubectl-${uniqueId}`,
                },
            },
        });
        this.layerVersionArn = core_1.Token.asString(resource.getAtt('Outputs.LayerVersionArn'));
    }
    /**
     * Gets or create a singleton instance of this construct.
     */
    static getOrCreate(scope, props = {}) {
        const stack = core_1.Stack.of(scope);
        const id = 'kubectl-layer-' + (props.version ? props.version : '8C2542BC-BF2B-4DFE-B765-E181FD30A9A0');
        const exists = stack.node.tryFindChild(id);
        if (exists) {
            return exists;
        }
        return new KubectlLayer(stack, id, props);
    }
    get stack() {
        return core_1.Stack.of(this);
    }
    addPermission(_id, _permission) {
        return;
    }
    isChina() {
        const region = this.stack.region;
        return !core_1.Token.isUnresolved(region) && region.startsWith('cn-');
    }
}
exports.KubectlLayer = KubectlLayer;
//# sourceMappingURL=data:application/json;base64,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