"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Values for `kubectl patch` --type argument
 */
var PatchType;
(function (PatchType) {
    /**
     * JSON Patch, RFC 6902
     */
    PatchType["JSON"] = "json";
    /**
     * JSON Merge patch
     */
    PatchType["MERGE"] = "merge";
    /**
     * Strategic merge patch
     */
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * A CloudFormation resource which applies/restores a JSON patch into a
 * Kubernetes resource.
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 */
class KubernetesPatch extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = props.cluster._attachKubectlResourceScope(this);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: props.cluster._kubectlCreationRole.roleArn,
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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