"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateCluster = void 0;
const cluster_1 = require("./cluster");
/**
 * Defines an EKS cluster that runs entirely on AWS Fargate.
 *
 * The cluster is created with a default Fargate Profile that matches the
 * "default" and "kube-system" namespaces. You can add additional profiles using
 * `addFargateProfile`.
 */
class FargateCluster extends cluster_1.Cluster {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id, {
            ...props,
            defaultCapacity: 0,
            kubectlEnabled: true,
            coreDnsComputeType: (_a = props.coreDnsComputeType) !== null && _a !== void 0 ? _a : cluster_1.CoreDnsComputeType.FARGATE,
            version: props.version,
        });
        this.addFargateProfile((_c = (_b = props.defaultProfile) === null || _b === void 0 ? void 0 : _b.fargateProfileName) !== null && _c !== void 0 ? _c : (props.defaultProfile ? 'custom' : 'default'), (_d = props.defaultProfile) !== null && _d !== void 0 ? _d : {
            selectors: [
                { namespace: 'default' },
                { namespace: 'kube-system' },
            ],
        });
    }
}
exports.FargateCluster = FargateCluster;
//# sourceMappingURL=data:application/json;base64,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