import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::EFS::AccessPoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 */
export interface CfnAccessPointProps {
    /**
     * `AWS::EFS::AccessPoint.FileSystemId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
     */
    readonly fileSystemId: string;
    /**
     * `AWS::EFS::AccessPoint.AccessPointTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
     */
    readonly accessPointTags?: Array<CfnAccessPoint.AccessPointTagProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EFS::AccessPoint.ClientToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
     */
    readonly clientToken?: string;
    /**
     * `AWS::EFS::AccessPoint.PosixUser`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
     */
    readonly posixUser?: CfnAccessPoint.PosixUserProperty | cdk.IResolvable;
    /**
     * `AWS::EFS::AccessPoint.RootDirectory`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
     */
    readonly rootDirectory?: CfnAccessPoint.RootDirectoryProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::EFS::AccessPoint`
 *
 * @cloudformationResource AWS::EFS::AccessPoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html
 */
export declare class CfnAccessPoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::AccessPoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnAccessPoint;
    /**
     * @cloudformationAttribute AccessPointId
     */
    readonly attrAccessPointId: string;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::EFS::AccessPoint.FileSystemId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-filesystemid
     */
    fileSystemId: string;
    /**
     * `AWS::EFS::AccessPoint.AccessPointTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-accesspointtags
     */
    accessPointTags: Array<CfnAccessPoint.AccessPointTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::AccessPoint.ClientToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-clienttoken
     */
    clientToken: string | undefined;
    /**
     * `AWS::EFS::AccessPoint.PosixUser`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-posixuser
     */
    posixUser: CfnAccessPoint.PosixUserProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::AccessPoint.RootDirectory`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-accesspoint.html#cfn-efs-accesspoint-rootdirectory
     */
    rootDirectory: CfnAccessPoint.RootDirectoryProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::EFS::AccessPoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccessPointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAccessPoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html
     */
    interface AccessPointTagProperty {
        /**
         * `CfnAccessPoint.AccessPointTagProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-key
         */
        readonly key?: string;
        /**
         * `CfnAccessPoint.AccessPointTagProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-accesspointtag.html#cfn-efs-accesspoint-accesspointtag-value
         */
        readonly value?: string;
    }
}
export declare namespace CfnAccessPoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html
     */
    interface CreationInfoProperty {
        /**
         * `CfnAccessPoint.CreationInfoProperty.OwnerGid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-ownergid
         */
        readonly ownerGid: string;
        /**
         * `CfnAccessPoint.CreationInfoProperty.OwnerUid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-owneruid
         */
        readonly ownerUid: string;
        /**
         * `CfnAccessPoint.CreationInfoProperty.Permissions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-creationinfo.html#cfn-efs-accesspoint-creationinfo-permissions
         */
        readonly permissions: string;
    }
}
export declare namespace CfnAccessPoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html
     */
    interface PosixUserProperty {
        /**
         * `CfnAccessPoint.PosixUserProperty.Gid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-gid
         */
        readonly gid: string;
        /**
         * `CfnAccessPoint.PosixUserProperty.SecondaryGids`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-secondarygids
         */
        readonly secondaryGids?: string[];
        /**
         * `CfnAccessPoint.PosixUserProperty.Uid`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-posixuser.html#cfn-efs-accesspoint-posixuser-uid
         */
        readonly uid: string;
    }
}
export declare namespace CfnAccessPoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html
     */
    interface RootDirectoryProperty {
        /**
         * `CfnAccessPoint.RootDirectoryProperty.CreationInfo`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-creationinfo
         */
        readonly creationInfo?: CfnAccessPoint.CreationInfoProperty | cdk.IResolvable;
        /**
         * `CfnAccessPoint.RootDirectoryProperty.Path`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-accesspoint-rootdirectory.html#cfn-efs-accesspoint-rootdirectory-path
         */
        readonly path?: string;
    }
}
/**
 * Properties for defining a `AWS::EFS::FileSystem`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 */
export interface CfnFileSystemProps {
    /**
     * `AWS::EFS::FileSystem.Encrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
     */
    readonly encrypted?: boolean | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.FileSystemPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
     */
    readonly fileSystemPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.FileSystemTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
     */
    readonly fileSystemTags?: CfnFileSystem.ElasticFileSystemTagProperty[];
    /**
     * `AWS::EFS::FileSystem.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::EFS::FileSystem.LifecyclePolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
     */
    readonly lifecyclePolicies?: Array<CfnFileSystem.LifecyclePolicyProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EFS::FileSystem.PerformanceMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
     */
    readonly performanceMode?: string;
    /**
     * `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
     */
    readonly provisionedThroughputInMibps?: number;
    /**
     * `AWS::EFS::FileSystem.ThroughputMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
     */
    readonly throughputMode?: string;
}
/**
 * A CloudFormation `AWS::EFS::FileSystem`
 *
 * @cloudformationResource AWS::EFS::FileSystem
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html
 */
export declare class CfnFileSystem extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::FileSystem";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnFileSystem;
    /**
     * @cloudformationAttribute FileSystemId
     */
    readonly attrFileSystemId: string;
    /**
     * `AWS::EFS::FileSystem.Encrypted`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-encrypted
     */
    encrypted: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.FileSystemPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystempolicy
     */
    fileSystemPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.FileSystemTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-filesystemtags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EFS::FileSystem.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::EFS::FileSystem.LifecyclePolicies`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-lifecyclepolicies
     */
    lifecyclePolicies: Array<CfnFileSystem.LifecyclePolicyProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EFS::FileSystem.PerformanceMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-performancemode
     */
    performanceMode: string | undefined;
    /**
     * `AWS::EFS::FileSystem.ProvisionedThroughputInMibps`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-provisionedthroughputinmibps
     */
    provisionedThroughputInMibps: number | undefined;
    /**
     * `AWS::EFS::FileSystem.ThroughputMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-filesystem.html#cfn-efs-filesystem-throughputmode
     */
    throughputMode: string | undefined;
    /**
     * Create a new `AWS::EFS::FileSystem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnFileSystemProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFileSystem {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html
     */
    interface ElasticFileSystemTagProperty {
        /**
         * `CfnFileSystem.ElasticFileSystemTagProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-key
         */
        readonly key: string;
        /**
         * `CfnFileSystem.ElasticFileSystemTagProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-elasticfilesystemtag.html#cfn-efs-filesystem-elasticfilesystemtag-value
         */
        readonly value: string;
    }
}
export declare namespace CfnFileSystem {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html
     */
    interface LifecyclePolicyProperty {
        /**
         * `CfnFileSystem.LifecyclePolicyProperty.TransitionToIA`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-efs-filesystem-lifecyclepolicy.html#cfn-efs-filesystem-lifecyclepolicy-transitiontoia
         */
        readonly transitionToIa: string;
    }
}
/**
 * Properties for defining a `AWS::EFS::MountTarget`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
 */
export interface CfnMountTargetProps {
    /**
     * `AWS::EFS::MountTarget.FileSystemId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
     */
    readonly fileSystemId: string;
    /**
     * `AWS::EFS::MountTarget.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
     */
    readonly securityGroups: string[];
    /**
     * `AWS::EFS::MountTarget.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
     */
    readonly subnetId: string;
    /**
     * `AWS::EFS::MountTarget.IpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
     */
    readonly ipAddress?: string;
}
/**
 * A CloudFormation `AWS::EFS::MountTarget`
 *
 * @cloudformationResource AWS::EFS::MountTarget
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html
 */
export declare class CfnMountTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EFS::MountTarget";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnMountTarget;
    /**
     * @cloudformationAttribute IpAddress
     */
    readonly attrIpAddress: string;
    /**
     * `AWS::EFS::MountTarget.FileSystemId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-filesystemid
     */
    fileSystemId: string;
    /**
     * `AWS::EFS::MountTarget.SecurityGroups`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-securitygroups
     */
    securityGroups: string[];
    /**
     * `AWS::EFS::MountTarget.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-subnetid
     */
    subnetId: string;
    /**
     * `AWS::EFS::MountTarget.IpAddress`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-efs-mounttarget.html#cfn-efs-mounttarget-ipaddress
     */
    ipAddress: string | undefined;
    /**
     * Create a new `AWS::EFS::MountTarget`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMountTargetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
