"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const efs_generated_1 = require("./efs.generated");
/**
 * Represents the AccessPoint
 */
class AccessPoint extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new efs_generated_1.CfnAccessPoint(this, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
        this.fileSystem = props.fileSystem;
    }
    /**
     * Import an existing Access Point
     */
    static fromAccessPointId(scope, id, accessPointId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.accessPointId = accessPointId;
                this.accessPointArn = core_1.Stack.of(scope).formatArn({
                    service: 'elasticfilesystem',
                    resource: 'access-point',
                    resourceName: accessPointId,
                });
            }
        }
        return new Import(scope, id);
    }
}
exports.AccessPoint = AccessPoint;
//# sourceMappingURL=data:application/json;base64,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