"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplunkLogDriver = exports.SplunkLogFormat = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * Log Message Format
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * A log driver that sends log information to splunk Logs.
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions({
                'splunk-token': this.props.token,
                'splunk-url': this.props.url,
                'splunk-source': this.props.source,
                'splunk-sourcetype': this.props.sourceType,
                'splunk-index': this.props.index,
                'splunk-capath': this.props.caPath,
                'splunk-caname': this.props.caName,
                'splunk-insecureskipverify': this.props.insecureSkipVerify,
                'splunk-format': this.props.format,
                'splunk-verify-connection': this.props.verifyConnection,
                'splunk-gzip': this.props.gzip,
                'splunk-gzip-level': this.props.gzipLevel,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
//# sourceMappingURL=data:application/json;base64,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