import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::DMS::Certificate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * `AWS::DMS::Certificate.CertificateIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificateidentifier
     */
    readonly certificateIdentifier?: string;
    /**
     * `AWS::DMS::Certificate.CertificatePem`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatepem
     */
    readonly certificatePem?: string;
    /**
     * `AWS::DMS::Certificate.CertificateWallet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatewallet
     */
    readonly certificateWallet?: string;
}
/**
 * A CloudFormation `AWS::DMS::Certificate`
 *
 * @cloudformationResource AWS::DMS::Certificate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCertificate;
    /**
     * `AWS::DMS::Certificate.CertificateIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificateidentifier
     */
    certificateIdentifier: string | undefined;
    /**
     * `AWS::DMS::Certificate.CertificatePem`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatepem
     */
    certificatePem: string | undefined;
    /**
     * `AWS::DMS::Certificate.CertificateWallet`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html#cfn-dms-certificate-certificatewallet
     */
    certificateWallet: string | undefined;
    /**
     * Create a new `AWS::DMS::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnCertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::Endpoint`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 */
export interface CfnEndpointProps {
    /**
     * `AWS::DMS::Endpoint.EndpointType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype
     */
    readonly endpointType: string;
    /**
     * `AWS::DMS::Endpoint.EngineName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename
     */
    readonly engineName: string;
    /**
     * `AWS::DMS::Endpoint.CertificateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn
     */
    readonly certificateArn?: string;
    /**
     * `AWS::DMS::Endpoint.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename
     */
    readonly databaseName?: string;
    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings
     */
    readonly dynamoDbSettings?: CfnEndpoint.DynamoDbSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings
     */
    readonly elasticsearchSettings?: CfnEndpoint.ElasticsearchSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier
     */
    readonly endpointIdentifier?: string;
    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes
     */
    readonly extraConnectionAttributes?: string;
    /**
     * `AWS::DMS::Endpoint.KafkaSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings
     */
    readonly kafkaSettings?: CfnEndpoint.KafkaSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.KinesisSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings
     */
    readonly kinesisSettings?: CfnEndpoint.KinesisSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings
     */
    readonly mongoDbSettings?: CfnEndpoint.MongoDbSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings
     */
    readonly neptuneSettings?: CfnEndpoint.NeptuneSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password
     */
    readonly password?: string;
    /**
     * `AWS::DMS::Endpoint.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port
     */
    readonly port?: number;
    /**
     * `AWS::DMS::Endpoint.S3Settings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings
     */
    readonly s3Settings?: CfnEndpoint.S3SettingsProperty | cdk.IResolvable;
    /**
     * `AWS::DMS::Endpoint.ServerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername
     */
    readonly serverName?: string;
    /**
     * `AWS::DMS::Endpoint.SslMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode
     */
    readonly sslMode?: string;
    /**
     * `AWS::DMS::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::Endpoint.Username`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username
     */
    readonly username?: string;
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`
 *
 * @cloudformationResource AWS::DMS::Endpoint
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 */
export declare class CfnEndpoint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Endpoint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnEndpoint;
    /**
     * @cloudformationAttribute ExternalId
     */
    readonly attrExternalId: string;
    /**
     * `AWS::DMS::Endpoint.EndpointType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointtype
     */
    endpointType: string;
    /**
     * `AWS::DMS::Endpoint.EngineName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-enginename
     */
    engineName: string;
    /**
     * `AWS::DMS::Endpoint.CertificateArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-certificatearn
     */
    certificateArn: string | undefined;
    /**
     * `AWS::DMS::Endpoint.DatabaseName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-databasename
     */
    databaseName: string | undefined;
    /**
     * `AWS::DMS::Endpoint.DynamoDbSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-dynamodbsettings
     */
    dynamoDbSettings: CfnEndpoint.DynamoDbSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.ElasticsearchSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-elasticsearchsettings
     */
    elasticsearchSettings: CfnEndpoint.ElasticsearchSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.EndpointIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-endpointidentifier
     */
    endpointIdentifier: string | undefined;
    /**
     * `AWS::DMS::Endpoint.ExtraConnectionAttributes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-extraconnectionattributes
     */
    extraConnectionAttributes: string | undefined;
    /**
     * `AWS::DMS::Endpoint.KafkaSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kafkasettings
     */
    kafkaSettings: CfnEndpoint.KafkaSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.KinesisSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kinesissettings
     */
    kinesisSettings: CfnEndpoint.KinesisSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::DMS::Endpoint.MongoDbSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-mongodbsettings
     */
    mongoDbSettings: CfnEndpoint.MongoDbSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.NeptuneSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-neptunesettings
     */
    neptuneSettings: CfnEndpoint.NeptuneSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.Password`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-password
     */
    password: string | undefined;
    /**
     * `AWS::DMS::Endpoint.Port`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-port
     */
    port: number | undefined;
    /**
     * `AWS::DMS::Endpoint.S3Settings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-s3settings
     */
    s3Settings: CfnEndpoint.S3SettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::Endpoint.ServerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-servername
     */
    serverName: string | undefined;
    /**
     * `AWS::DMS::Endpoint.SslMode`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-sslmode
     */
    sslMode: string | undefined;
    /**
     * `AWS::DMS::Endpoint.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::Endpoint.Username`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html#cfn-dms-endpoint-username
     */
    username: string | undefined;
    /**
     * Create a new `AWS::DMS::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEndpointProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html
     */
    interface DynamoDbSettingsProperty {
        /**
         * `CfnEndpoint.DynamoDbSettingsProperty.ServiceAccessRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-dynamodbsettings.html#cfn-dms-endpoint-dynamodbsettings-serviceaccessrolearn
         */
        readonly serviceAccessRoleArn?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html
     */
    interface ElasticsearchSettingsProperty {
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.EndpointUri`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-endpointuri
         */
        readonly endpointUri?: string;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ErrorRetryDuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-errorretryduration
         */
        readonly errorRetryDuration?: number;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.FullLoadErrorPercentage`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-fullloaderrorpercentage
         */
        readonly fullLoadErrorPercentage?: number;
        /**
         * `CfnEndpoint.ElasticsearchSettingsProperty.ServiceAccessRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-elasticsearchsettings.html#cfn-dms-endpoint-elasticsearchsettings-serviceaccessrolearn
         */
        readonly serviceAccessRoleArn?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html
     */
    interface KafkaSettingsProperty {
        /**
         * `CfnEndpoint.KafkaSettingsProperty.Broker`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-broker
         */
        readonly broker?: string;
        /**
         * `CfnEndpoint.KafkaSettingsProperty.Topic`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kafkasettings.html#cfn-dms-endpoint-kafkasettings-topic
         */
        readonly topic?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html
     */
    interface KinesisSettingsProperty {
        /**
         * `CfnEndpoint.KinesisSettingsProperty.MessageFormat`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-messageformat
         */
        readonly messageFormat?: string;
        /**
         * `CfnEndpoint.KinesisSettingsProperty.ServiceAccessRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-serviceaccessrolearn
         */
        readonly serviceAccessRoleArn?: string;
        /**
         * `CfnEndpoint.KinesisSettingsProperty.StreamArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-kinesissettings.html#cfn-dms-endpoint-kinesissettings-streamarn
         */
        readonly streamArn?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html
     */
    interface MongoDbSettingsProperty {
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthMechanism`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authmechanism
         */
        readonly authMechanism?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthSource`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authsource
         */
        readonly authSource?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.AuthType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-authtype
         */
        readonly authType?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DatabaseName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.DocsToInvestigate`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-docstoinvestigate
         */
        readonly docsToInvestigate?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ExtractDocId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-extractdocid
         */
        readonly extractDocId?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.NestingLevel`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-nestinglevel
         */
        readonly nestingLevel?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Password`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-password
         */
        readonly password?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Port`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-port
         */
        readonly port?: number;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.ServerName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-servername
         */
        readonly serverName?: string;
        /**
         * `CfnEndpoint.MongoDbSettingsProperty.Username`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-mongodbsettings.html#cfn-dms-endpoint-mongodbsettings-username
         */
        readonly username?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html
     */
    interface NeptuneSettingsProperty {
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ErrorRetryDuration`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-errorretryduration
         */
        readonly errorRetryDuration?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.IamAuthEnabled`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-iamauthenabled
         */
        readonly iamAuthEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxFileSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxfilesize
         */
        readonly maxFileSize?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.MaxRetryCount`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-maxretrycount
         */
        readonly maxRetryCount?: number;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketFolder`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketfolder
         */
        readonly s3BucketFolder?: string;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.S3BucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-s3bucketname
         */
        readonly s3BucketName?: string;
        /**
         * `CfnEndpoint.NeptuneSettingsProperty.ServiceAccessRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-neptunesettings.html#cfn-dms-endpoint-neptunesettings-serviceaccessrolearn
         */
        readonly serviceAccessRoleArn?: string;
    }
}
export declare namespace CfnEndpoint {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html
     */
    interface S3SettingsProperty {
        /**
         * `CfnEndpoint.S3SettingsProperty.BucketFolder`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketfolder
         */
        readonly bucketFolder?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.BucketName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-bucketname
         */
        readonly bucketName?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CompressionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-compressiontype
         */
        readonly compressionType?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CsvDelimiter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvdelimiter
         */
        readonly csvDelimiter?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.CsvRowDelimiter`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-csvrowdelimiter
         */
        readonly csvRowDelimiter?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.ExternalTableDefinition`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-externaltabledefinition
         */
        readonly externalTableDefinition?: string;
        /**
         * `CfnEndpoint.S3SettingsProperty.ServiceAccessRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dms-endpoint-s3settings.html#cfn-dms-endpoint-s3settings-serviceaccessrolearn
         */
        readonly serviceAccessRoleArn?: string;
    }
}
/**
 * Properties for defining a `AWS::DMS::EventSubscription`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 */
export interface CfnEventSubscriptionProps {
    /**
     * `AWS::DMS::EventSubscription.SnsTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-snstopicarn
     */
    readonly snsTopicArn: string;
    /**
     * `AWS::DMS::EventSubscription.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::EventSubscription.EventCategories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-eventcategories
     */
    readonly eventCategories?: string[];
    /**
     * `AWS::DMS::EventSubscription.SourceIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourceids
     */
    readonly sourceIds?: string[];
    /**
     * `AWS::DMS::EventSubscription.SourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourcetype
     */
    readonly sourceType?: string;
    /**
     * `AWS::DMS::EventSubscription.SubscriptionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-subscriptionname
     */
    readonly subscriptionName?: string;
    /**
     * `AWS::DMS::EventSubscription.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DMS::EventSubscription`
 *
 * @cloudformationResource AWS::DMS::EventSubscription
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 */
export declare class CfnEventSubscription extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::EventSubscription";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnEventSubscription;
    /**
     * `AWS::DMS::EventSubscription.SnsTopicArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-snstopicarn
     */
    snsTopicArn: string;
    /**
     * `AWS::DMS::EventSubscription.Enabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::EventSubscription.EventCategories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-eventcategories
     */
    eventCategories: string[] | undefined;
    /**
     * `AWS::DMS::EventSubscription.SourceIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourceids
     */
    sourceIds: string[] | undefined;
    /**
     * `AWS::DMS::EventSubscription.SourceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-sourcetype
     */
    sourceType: string | undefined;
    /**
     * `AWS::DMS::EventSubscription.SubscriptionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-subscriptionname
     */
    subscriptionName: string | undefined;
    /**
     * `AWS::DMS::EventSubscription.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html#cfn-dms-eventsubscription-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DMS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSubscriptionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationInstance`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 */
export interface CfnReplicationInstanceProps {
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceclass
     */
    readonly replicationInstanceClass: string;
    /**
     * `AWS::DMS::ReplicationInstance.AllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allocatedstorage
     */
    readonly allocatedStorage?: number;
    /**
     * `AWS::DMS::ReplicationInstance.AllowMajorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allowmajorversionupgrade
     */
    readonly allowMajorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-autominorversionupgrade
     */
    readonly autoMinorVersionUpgrade?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-availabilityzone
     */
    readonly availabilityZone?: string;
    /**
     * `AWS::DMS::ReplicationInstance.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-engineversion
     */
    readonly engineVersion?: string;
    /**
     * `AWS::DMS::ReplicationInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-kmskeyid
     */
    readonly kmsKeyId?: string;
    /**
     * `AWS::DMS::ReplicationInstance.MultiAZ`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-multiaz
     */
    readonly multiAz?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-preferredmaintenancewindow
     */
    readonly preferredMaintenanceWindow?: string;
    /**
     * `AWS::DMS::ReplicationInstance.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-publiclyaccessible
     */
    readonly publiclyAccessible?: boolean | cdk.IResolvable;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceidentifier
     */
    readonly replicationInstanceIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationSubnetGroupIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationsubnetgroupidentifier
     */
    readonly replicationSubnetGroupIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::ReplicationInstance.VpcSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-vpcsecuritygroupids
     */
    readonly vpcSecurityGroupIds?: string[];
}
/**
 * A CloudFormation `AWS::DMS::ReplicationInstance`
 *
 * @cloudformationResource AWS::DMS::ReplicationInstance
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 */
export declare class CfnReplicationInstance extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationInstance";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnReplicationInstance;
    /**
     * @cloudformationAttribute ReplicationInstancePrivateIpAddresses
     */
    readonly attrReplicationInstancePrivateIpAddresses: string[];
    /**
     * @cloudformationAttribute ReplicationInstancePublicIpAddresses
     */
    readonly attrReplicationInstancePublicIpAddresses: string[];
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceClass`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceclass
     */
    replicationInstanceClass: string;
    /**
     * `AWS::DMS::ReplicationInstance.AllocatedStorage`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allocatedstorage
     */
    allocatedStorage: number | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AllowMajorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-allowmajorversionupgrade
     */
    allowMajorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AutoMinorVersionUpgrade`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-autominorversionupgrade
     */
    autoMinorVersionUpgrade: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.AvailabilityZone`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-availabilityzone
     */
    availabilityZone: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.EngineVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-engineversion
     */
    engineVersion: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.KmsKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-kmskeyid
     */
    kmsKeyId: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.MultiAZ`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-multiaz
     */
    multiAz: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.PreferredMaintenanceWindow`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-preferredmaintenancewindow
     */
    preferredMaintenanceWindow: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.PubliclyAccessible`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-publiclyaccessible
     */
    publiclyAccessible: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationInstanceIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationinstanceidentifier
     */
    replicationInstanceIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.ReplicationSubnetGroupIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-replicationsubnetgroupidentifier
     */
    replicationSubnetGroupIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationInstance.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::ReplicationInstance.VpcSecurityGroupIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html#cfn-dms-replicationinstance-vpcsecuritygroupids
     */
    vpcSecurityGroupIds: string[] | undefined;
    /**
     * Create a new `AWS::DMS::ReplicationInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationInstanceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationSubnetGroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 */
export interface CfnReplicationSubnetGroupProps {
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupdescription
     */
    readonly replicationSubnetGroupDescription: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-subnetids
     */
    readonly subnetIds: string[];
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupidentifier
     */
    readonly replicationSubnetGroupIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DMS::ReplicationSubnetGroup`
 *
 * @cloudformationResource AWS::DMS::ReplicationSubnetGroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 */
export declare class CfnReplicationSubnetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationSubnetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnReplicationSubnetGroup;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupdescription
     */
    replicationSubnetGroupDescription: string;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.SubnetIds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-subnetids
     */
    subnetIds: string[];
    /**
     * `AWS::DMS::ReplicationSubnetGroup.ReplicationSubnetGroupIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-replicationsubnetgroupidentifier
     */
    replicationSubnetGroupIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationSubnetGroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html#cfn-dms-replicationsubnetgroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DMS::ReplicationSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationSubnetGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DMS::ReplicationTask`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 */
export interface CfnReplicationTaskProps {
    /**
     * `AWS::DMS::ReplicationTask.MigrationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-migrationtype
     */
    readonly migrationType: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationInstanceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationinstancearn
     */
    readonly replicationInstanceArn: string;
    /**
     * `AWS::DMS::ReplicationTask.SourceEndpointArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-sourceendpointarn
     */
    readonly sourceEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.TableMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tablemappings
     */
    readonly tableMappings: string;
    /**
     * `AWS::DMS::ReplicationTask.TargetEndpointArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-targetendpointarn
     */
    readonly targetEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstartposition
     */
    readonly cdcStartPosition?: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstarttime
     */
    readonly cdcStartTime?: number;
    /**
     * `AWS::DMS::ReplicationTask.CdcStopPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstopposition
     */
    readonly cdcStopPosition?: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtaskidentifier
     */
    readonly replicationTaskIdentifier?: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtasksettings
     */
    readonly replicationTaskSettings?: string;
    /**
     * `AWS::DMS::ReplicationTask.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DMS::ReplicationTask.TaskData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-taskdata
     */
    readonly taskData?: string;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationTask`
 *
 * @cloudformationResource AWS::DMS::ReplicationTask
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 */
export declare class CfnReplicationTask extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationTask";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnReplicationTask;
    /**
     * `AWS::DMS::ReplicationTask.MigrationType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-migrationtype
     */
    migrationType: string;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationInstanceArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationinstancearn
     */
    replicationInstanceArn: string;
    /**
     * `AWS::DMS::ReplicationTask.SourceEndpointArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-sourceendpointarn
     */
    sourceEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.TableMappings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tablemappings
     */
    tableMappings: string;
    /**
     * `AWS::DMS::ReplicationTask.TargetEndpointArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-targetendpointarn
     */
    targetEndpointArn: string;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstartposition
     */
    cdcStartPosition: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.CdcStartTime`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstarttime
     */
    cdcStartTime: number | undefined;
    /**
     * `AWS::DMS::ReplicationTask.CdcStopPosition`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-cdcstopposition
     */
    cdcStopPosition: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskIdentifier`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtaskidentifier
     */
    replicationTaskIdentifier: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.ReplicationTaskSettings`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-replicationtasksettings
     */
    replicationTaskSettings: string | undefined;
    /**
     * `AWS::DMS::ReplicationTask.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DMS::ReplicationTask.TaskData`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html#cfn-dms-replicationtask-taskdata
     */
    taskData: string | undefined;
    /**
     * Create a new `AWS::DMS::ReplicationTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnReplicationTaskProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
