import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CodeCommit::Repository`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 */
export interface CfnRepositoryProps {
    /**
     * `AWS::CodeCommit::Repository.RepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     */
    readonly repositoryName: string;
    /**
     * `AWS::CodeCommit::Repository.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     */
    readonly code?: CfnRepository.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     */
    readonly repositoryDescription?: string;
    /**
     * `AWS::CodeCommit::Repository.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CodeCommit::Repository.Triggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     */
    readonly triggers?: Array<CfnRepository.RepositoryTriggerProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::CodeCommit::Repository`
 *
 * @cloudformationResource AWS::CodeCommit::Repository
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html
 */
export declare class CfnRepository extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CodeCommit::Repository";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnRepository;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CloneUrlHttp
     */
    readonly attrCloneUrlHttp: string;
    /**
     * @cloudformationAttribute CloneUrlSsh
     */
    readonly attrCloneUrlSsh: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly attrName: string;
    /**
     * `AWS::CodeCommit::Repository.RepositoryName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositoryname
     */
    repositoryName: string;
    /**
     * `AWS::CodeCommit::Repository.Code`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-code
     */
    code: CfnRepository.CodeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::CodeCommit::Repository.RepositoryDescription`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-repositorydescription
     */
    repositoryDescription: string | undefined;
    /**
     * `AWS::CodeCommit::Repository.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CodeCommit::Repository.Triggers`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codecommit-repository.html#cfn-codecommit-repository-triggers
     */
    triggers: Array<CfnRepository.RepositoryTriggerProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::CodeCommit::Repository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRepositoryProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html
     */
    interface CodeProperty {
        /**
         * `CfnRepository.CodeProperty.S3`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-code.html#cfn-codecommit-repository-code-s3
         */
        readonly s3: CfnRepository.S3Property | cdk.IResolvable;
    }
}
export declare namespace CfnRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html
     */
    interface RepositoryTriggerProperty {
        /**
         * `CfnRepository.RepositoryTriggerProperty.Branches`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-branches
         */
        readonly branches?: string[];
        /**
         * `CfnRepository.RepositoryTriggerProperty.CustomData`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-customdata
         */
        readonly customData?: string;
        /**
         * `CfnRepository.RepositoryTriggerProperty.DestinationArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-destinationarn
         */
        readonly destinationArn: string;
        /**
         * `CfnRepository.RepositoryTriggerProperty.Events`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-events
         */
        readonly events: string[];
        /**
         * `CfnRepository.RepositoryTriggerProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-repositorytrigger.html#cfn-codecommit-repository-repositorytrigger-name
         */
        readonly name: string;
    }
}
export declare namespace CfnRepository {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html
     */
    interface S3Property {
        /**
         * `CfnRepository.S3Property.Bucket`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-bucket
         */
        readonly bucket: string;
        /**
         * `CfnRepository.S3Property.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-key
         */
        readonly key: string;
        /**
         * `CfnRepository.S3Property.ObjectVersion`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codecommit-repository-s3.html#cfn-codecommit-repository-s3-objectversion
         */
        readonly objectVersion?: string;
    }
}
