"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BitBucketSourceCredentials = exports.GitHubEnterpriseSourceCredentials = exports.GitHubSourceCredentials = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const codebuild_generated_1 = require("./codebuild.generated");
/**
 * The source credentials used when contacting the GitHub API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubSourceCredentials = GitHubSourceCredentials;
/**
 * The source credentials used when contacting the GitHub Enterprise API.
 *
 * **Note**: CodeBuild only allows a single credential for GitHub Enterprise
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class GitHubEnterpriseSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'GITHUB_ENTERPRISE',
            authType: 'PERSONAL_ACCESS_TOKEN',
            token: props.accessToken.toString(),
        });
    }
}
exports.GitHubEnterpriseSourceCredentials = GitHubEnterpriseSourceCredentials;
/**
 * The source credentials used when contacting the BitBucket API.
 *
 * **Note**: CodeBuild only allows a single credential for BitBucket
 * to be saved in a given AWS account in a given region -
 * any attempt to add more than one will result in an error.
 *
 * @resource AWS::CodeBuild::SourceCredential
 */
class BitBucketSourceCredentials extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        new codebuild_generated_1.CfnSourceCredential(this, 'Resource', {
            serverType: 'BITBUCKET',
            authType: 'BASIC_AUTH',
            username: props.username.toString(),
            token: props.password.toString(),
        });
    }
}
exports.BitBucketSourceCredentials = BitBucketSourceCredentials;
//# sourceMappingURL=data:application/json;base64,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