"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhaseChangeEvent = exports.StateChangeEvent = void 0;
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
/**
 * Event fields for the CodeBuild "state change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class StateChangeEvent {
    /**
     * The triggering build's status
     */
    static get buildStatus() {
        return events.EventField.fromPath('$.detail.build-status');
    }
    /**
     * The triggering build's project name
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * Return the build id
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    static get currentPhase() {
        return events.EventField.fromPath('$.detail.current-phase');
    }
    constructor() {
    }
}
exports.StateChangeEvent = StateChangeEvent;
/**
 * Event fields for the CodeBuild "phase change" event
 *
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-build-notifications.html#sample-build-notifications-ref
 */
class PhaseChangeEvent {
    /**
     * The triggering build's project name
     */
    static get projectName() {
        return events.EventField.fromPath('$.detail.project-name');
    }
    /**
     * The triggering build's id
     */
    static get buildId() {
        return events.EventField.fromPath('$.detail.build-id');
    }
    /**
     * The phase that was just completed
     */
    static get completedPhase() {
        return events.EventField.fromPath('$.detail.completed-phase');
    }
    /**
     * The status of the completed phase
     */
    static get completedPhaseStatus() {
        return events.EventField.fromPath('$.detail.completed-phase-status');
    }
    /**
     * The duration of the completed phase
     */
    static get completedPhaseDurationSeconds() {
        return events.EventField.fromPath('$.detail.completed-phase-duration-seconds');
    }
    /**
     * Whether the build is complete
     */
    static get buildComplete() {
        return events.EventField.fromPath('$.detail.build-complete');
    }
    constructor() {
    }
}
exports.PhaseChangeEvent = PhaseChangeEvent;
//# sourceMappingURL=data:application/json;base64,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