"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingAction = void 0;
/**
 * Use an AutoScaling StepScalingAction as an Alarm Action
 */
class AutoScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
    }
    /**
     * Returns an alarm action configuration to use an AutoScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.AutoScalingAction = AutoScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0b3NjYWxpbmcuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhdXRvc2NhbGluZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHQTs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzFCLFlBQTZCLGlCQUFnRDtRQUFoRCxzQkFBaUIsR0FBakIsaUJBQWlCLENBQStCO0lBQzdFLENBQUM7SUFDRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsTUFBcUIsRUFBRSxNQUF5QjtRQUN4RCxPQUFPLEVBQUUsY0FBYyxFQUFFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO0lBQ3ZFLENBQUM7Q0FDSjtBQVZELDhDQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXV0b3NjYWxpbmcgZnJvbSBcIi4uLy4uL2F3cy1hdXRvc2NhbGluZ1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWF1dG9zY2FsaW5nJ1xuaW1wb3J0ICogYXMgY2xvdWR3YXRjaCBmcm9tIFwiLi4vLi4vYXdzLWNsb3Vkd2F0Y2hcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZHdhdGNoJ1xuaW1wb3J0ICogYXMgY2RrIGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuLyoqXG4gKiBVc2UgYW4gQXV0b1NjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb24gYXMgYW4gQWxhcm0gQWN0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBdXRvU2NhbGluZ0FjdGlvbiBpbXBsZW1lbnRzIGNsb3Vkd2F0Y2guSUFsYXJtQWN0aW9uIHtcbiAgICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHN0ZXBTY2FsaW5nQWN0aW9uOiBhdXRvc2NhbGluZy5TdGVwU2NhbGluZ0FjdGlvbikge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGFuIGFsYXJtIGFjdGlvbiBjb25maWd1cmF0aW9uIHRvIHVzZSBhbiBBdXRvU2NhbGluZyBTdGVwU2NhbGluZ0FjdGlvblxuICAgICAqIGFzIGFuIGFsYXJtIGFjdGlvblxuICAgICAqL1xuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogY2RrLkNvbnN0cnVjdCwgX2FsYXJtOiBjbG91ZHdhdGNoLklBbGFybSk6IGNsb3Vkd2F0Y2guQWxhcm1BY3Rpb25Db25maWcge1xuICAgICAgICByZXR1cm4geyBhbGFybUFjdGlvbkFybjogdGhpcy5zdGVwU2NhbGluZ0FjdGlvbi5zY2FsaW5nUG9saWN5QXJuIH07XG4gICAgfVxufVxuIl19