"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResource = exports.CustomResourceProvider = void 0;
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Represents a provider for an AWS CloudFormation custom resources.
 */
class CustomResourceProvider {
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    constructor(serviceToken) {
        this.serviceToken = serviceToken;
    }
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static fromLambda(handler) {
        return new CustomResourceProvider(handler.functionArn);
    }
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static fromTopic(topic) {
        return new CustomResourceProvider(topic.topicArn);
    }
    /**
     * Use AWS Lambda as a provider.
     * @deprecated use `fromLambda`
     */
    static lambda(handler) { return this.fromLambda(handler); }
    /**
     * Use an SNS topic as the provider.
     * @deprecated use `fromTopic`
     */
    static topic(topic) { return this.fromTopic(topic); }
    bind(_) {
        return { serviceToken: this.serviceToken };
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
/**
 * Deprecated.
 * @deprecated use `core.CustomResource`
 */
class CustomResource extends core.CustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            pascalCaseProperties: true,
            properties: props.properties,
            removalPolicy: props.removalPolicy,
            resourceType: props.resourceType,
            serviceToken: core.Lazy.stringValue({ produce: () => props.provider.bind(this).serviceToken }),
        });
    }
}
exports.CustomResource = CustomResource;
//# sourceMappingURL=data:application/json;base64,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