import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CloudFormation::CustomResource`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html
 */
export interface CfnCustomResourceProps {
    /**
     * `AWS::CloudFormation::CustomResource.ServiceToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#cfn-customresource-servicetoken
     */
    readonly serviceToken: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::CustomResource`
 *
 * @cloudformationResource AWS::CloudFormation::CustomResource
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html
 */
export declare class CfnCustomResource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::CustomResource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCustomResource;
    /**
     * `AWS::CloudFormation::CustomResource.ServiceToken`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#cfn-customresource-servicetoken
     */
    serviceToken: string;
    /**
     * Create a new `AWS::CloudFormation::CustomResource`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomResourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::Macro`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html
 */
export interface CfnMacroProps {
    /**
     * `AWS::CloudFormation::Macro.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-functionname
     */
    readonly functionName: string;
    /**
     * `AWS::CloudFormation::Macro.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-name
     */
    readonly name: string;
    /**
     * `AWS::CloudFormation::Macro.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-description
     */
    readonly description?: string;
    /**
     * `AWS::CloudFormation::Macro.LogGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-loggroupname
     */
    readonly logGroupName?: string;
    /**
     * `AWS::CloudFormation::Macro.LogRoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-logrolearn
     */
    readonly logRoleArn?: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::Macro`
 *
 * @cloudformationResource AWS::CloudFormation::Macro
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html
 */
export declare class CfnMacro extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Macro";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnMacro;
    /**
     * `AWS::CloudFormation::Macro.FunctionName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-functionname
     */
    functionName: string;
    /**
     * `AWS::CloudFormation::Macro.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-name
     */
    name: string;
    /**
     * `AWS::CloudFormation::Macro.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-description
     */
    description: string | undefined;
    /**
     * `AWS::CloudFormation::Macro.LogGroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-loggroupname
     */
    logGroupName: string | undefined;
    /**
     * `AWS::CloudFormation::Macro.LogRoleARN`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-macro.html#cfn-cloudformation-macro-logrolearn
     */
    logRoleArn: string | undefined;
    /**
     * Create a new `AWS::CloudFormation::Macro`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMacroProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::Stack`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html
 */
export interface CfnStackProps {
    /**
     * `AWS::CloudFormation::Stack.TemplateURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     */
    readonly templateUrl: string;
    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::CloudFormation::Stack.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     */
    readonly parameters?: {
        [key: string]: (string);
    } | cdk.IResolvable;
    /**
     * `AWS::CloudFormation::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     */
    readonly timeoutInMinutes?: number;
}
/**
 * A CloudFormation `AWS::CloudFormation::Stack`
 *
 * @cloudformationResource AWS::CloudFormation::Stack
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Stack";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnStack;
    /**
     * `AWS::CloudFormation::Stack.TemplateURL`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-templateurl
     */
    templateUrl: string;
    /**
     * `AWS::CloudFormation::Stack.NotificationARNs`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-notificationarns
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::CloudFormation::Stack.Parameters`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-parameters
     */
    parameters: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * `AWS::CloudFormation::Stack.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CloudFormation::Stack.TimeoutInMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-stack.html#cfn-cloudformation-stack-timeoutinminutes
     */
    timeoutInMinutes: number | undefined;
    /**
     * Create a new `AWS::CloudFormation::Stack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::CloudFormation::WaitCondition`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html
 */
export interface CfnWaitConditionProps {
    /**
     * `AWS::CloudFormation::WaitCondition.Count`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-count
     */
    readonly count?: number;
    /**
     * `AWS::CloudFormation::WaitCondition.Handle`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-handle
     */
    readonly handle?: string;
    /**
     * `AWS::CloudFormation::WaitCondition.Timeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-timeout
     */
    readonly timeout?: string;
}
/**
 * A CloudFormation `AWS::CloudFormation::WaitCondition`
 *
 * @cloudformationResource AWS::CloudFormation::WaitCondition
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html
 */
export declare class CfnWaitCondition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::WaitCondition";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnWaitCondition;
    /**
     * @cloudformationAttribute Data
     */
    readonly attrData: cdk.IResolvable;
    /**
     * `AWS::CloudFormation::WaitCondition.Count`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-count
     */
    count: number | undefined;
    /**
     * `AWS::CloudFormation::WaitCondition.Handle`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-handle
     */
    handle: string | undefined;
    /**
     * `AWS::CloudFormation::WaitCondition.Timeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitcondition.html#cfn-waitcondition-timeout
     */
    timeout: string | undefined;
    /**
     * Create a new `AWS::CloudFormation::WaitCondition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnWaitConditionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::CloudFormation::WaitConditionHandle`
 *
 * @cloudformationResource AWS::CloudFormation::WaitConditionHandle
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-waitconditionhandle.html
 */
export declare class CfnWaitConditionHandle extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::WaitConditionHandle";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnWaitConditionHandle;
    /**
     * Create a new `AWS::CloudFormation::WaitConditionHandle`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
}
