"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationCapabilities = void 0;
/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources
 * @deprecated use `core.CfnCapabilities`
 */
var CloudFormationCapabilities;
(function (CloudFormationCapabilities) {
    /**
     * No IAM Capabilities
     *
     * Pass this capability if you wish to block the creation IAM resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["NONE"] = "";
    /**
     * Capability to create anonymous IAM resources
     *
     * Pass this capability if you're only creating anonymous resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["ANONYMOUS_IAM"] = "CAPABILITY_IAM";
    /**
     * Capability to create named IAM resources.
     *
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     *
     * `CloudFormationCapabilities.NamedIAM` implies `CloudFormationCapabilities.IAM`; you don't have to pass both.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["NAMED_IAM"] = "CAPABILITY_NAMED_IAM";
    /**
     * Capability to run CloudFormation macros
     *
     * Pass this capability if your template includes macros, for example AWS::Include or AWS::Serverless.
     *
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_CreateStack.html
     */
    CloudFormationCapabilities["AUTO_EXPAND"] = "CAPABILITY_AUTO_EXPAND";
})(CloudFormationCapabilities = exports.CloudFormationCapabilities || (exports.CloudFormationCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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