import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::CertificateManager::Certificate`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * `AWS::CertificateManager::Certificate.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     */
    readonly domainName: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificateauthorityarn
     */
    readonly certificateAuthorityArn?: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateTransparencyLoggingPreference`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificatetransparencyloggingpreference
     */
    readonly certificateTransparencyLoggingPreference?: string;
    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     */
    readonly domainValidationOptions?: Array<CfnCertificate.DomainValidationOptionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     */
    readonly subjectAlternativeNames?: string[];
    /**
     * `AWS::CertificateManager::Certificate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     */
    readonly validationMethod?: string;
}
/**
 * A CloudFormation `AWS::CertificateManager::Certificate`
 *
 * @cloudformationResource AWS::CertificateManager::Certificate
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::CertificateManager::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnCertificate;
    /**
     * `AWS::CertificateManager::Certificate.DomainName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainname
     */
    domainName: string;
    /**
     * `AWS::CertificateManager::Certificate.CertificateAuthorityArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificateauthorityarn
     */
    certificateAuthorityArn: string | undefined;
    /**
     * `AWS::CertificateManager::Certificate.CertificateTransparencyLoggingPreference`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-certificatetransparencyloggingpreference
     */
    certificateTransparencyLoggingPreference: string | undefined;
    /**
     * `AWS::CertificateManager::Certificate.DomainValidationOptions`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-domainvalidationoptions
     */
    domainValidationOptions: Array<CfnCertificate.DomainValidationOptionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::CertificateManager::Certificate.SubjectAlternativeNames`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-subjectalternativenames
     */
    subjectAlternativeNames: string[] | undefined;
    /**
     * `AWS::CertificateManager::Certificate.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::CertificateManager::Certificate.ValidationMethod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-validationmethod
     */
    validationMethod: string | undefined;
    /**
     * Create a new `AWS::CertificateManager::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCertificate {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html
     */
    interface DomainValidationOptionProperty {
        /**
         * `CfnCertificate.DomainValidationOptionProperty.DomainName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoptions-domainname
         */
        readonly domainName: string;
        /**
         * `CfnCertificate.DomainValidationOptionProperty.HostedZoneId`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-hostedzoneid
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnCertificate.DomainValidationOptionProperty.ValidationDomain`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-certificatemanager-certificate-domainvalidationoption.html#cfn-certificatemanager-certificate-domainvalidationoption-validationdomain
         */
        readonly validationDomain?: string;
    }
}
