"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupableResourcesCollector = void 0;
const dynamodb = require("../../aws-dynamodb"); // Automatically re-written from '@aws-cdk/aws-dynamodb'
const ec2 = require("../../aws-ec2"); // Automatically re-written from '@aws-cdk/aws-ec2'
const efs = require("../../aws-efs"); // Automatically re-written from '@aws-cdk/aws-efs'
const rds = require("../../aws-rds"); // Automatically re-written from '@aws-cdk/aws-rds'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
class BackupableResourcesCollector {
    constructor() {
        this.resources = [];
    }
    visit(node) {
        if (node instanceof efs.CfnFileSystem) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'elasticfilesystem',
                resource: 'file-system',
                resourceName: node.ref,
            }));
        }
        if (node instanceof dynamodb.CfnTable) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'dynamodb',
                resource: 'table',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'instance',
                resourceName: node.ref,
            }));
        }
        if (node instanceof ec2.CfnVolume) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'ec2',
                resource: 'volume',
                resourceName: node.ref,
            }));
        }
        if (node instanceof rds.CfnDBInstance) {
            this.resources.push(core_1.Stack.of(node).formatArn({
                service: 'rds',
                resource: 'db',
                sep: ':',
                resourceName: node.ref,
            }));
        }
    }
}
exports.BackupableResourcesCollector = BackupableResourcesCollector;
//# sourceMappingURL=data:application/json;base64,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