import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Backup::BackupPlan`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export interface CfnBackupPlanProps {
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     */
    readonly backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     */
    readonly backupPlanTags?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupPlan`
 *
 * @cloudformationResource AWS::Backup::BackupPlan
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html
 */
export declare class CfnBackupPlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupPlan";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnBackupPlan;
    /**
     * @cloudformationAttribute BackupPlanArn
     */
    readonly attrBackupPlanArn: string;
    /**
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @cloudformationAttribute VersionId
     */
    readonly attrVersionId: string;
    /**
     * `AWS::Backup::BackupPlan.BackupPlan`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan
     */
    backupPlan: CfnBackupPlan.BackupPlanResourceTypeProperty | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupPlan.BackupPlanTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags
     */
    backupPlanTags: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupPlan`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupPlanProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBackupPlan {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html
     */
    interface BackupPlanResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanname
         */
        readonly backupPlanName: string;
        /**
         * `CfnBackupPlan.BackupPlanResourceTypeProperty.BackupPlanRule`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupplanresourcetype.html#cfn-backup-backupplan-backupplanresourcetype-backupplanrule
         */
        readonly backupPlanRule: Array<CfnBackupPlan.BackupRuleResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnBackupPlan {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html
     */
    interface BackupRuleResourceTypeProperty {
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CompletionWindowMinutes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-completionwindowminutes
         */
        readonly completionWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.CopyActions`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-copyactions
         */
        readonly copyActions?: Array<CfnBackupPlan.CopyActionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.Lifecycle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-lifecycle
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RecoveryPointTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-recoverypointtags
         */
        readonly recoveryPointTags?: any | cdk.IResolvable;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.RuleName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-rulename
         */
        readonly ruleName: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.ScheduleExpression`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-scheduleexpression
         */
        readonly scheduleExpression?: string;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.StartWindowMinutes`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-startwindowminutes
         */
        readonly startWindowMinutes?: number;
        /**
         * `CfnBackupPlan.BackupRuleResourceTypeProperty.TargetBackupVault`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-backupruleresourcetype.html#cfn-backup-backupplan-backupruleresourcetype-targetbackupvault
         */
        readonly targetBackupVault: string;
    }
}
export declare namespace CfnBackupPlan {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html
     */
    interface CopyActionResourceTypeProperty {
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.DestinationBackupVaultArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-destinationbackupvaultarn
         */
        readonly destinationBackupVaultArn: string;
        /**
         * `CfnBackupPlan.CopyActionResourceTypeProperty.Lifecycle`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-copyactionresourcetype.html#cfn-backup-backupplan-copyactionresourcetype-lifecycle
         */
        readonly lifecycle?: CfnBackupPlan.LifecycleResourceTypeProperty | cdk.IResolvable;
    }
}
export declare namespace CfnBackupPlan {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html
     */
    interface LifecycleResourceTypeProperty {
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.DeleteAfterDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-deleteafterdays
         */
        readonly deleteAfterDays?: number;
        /**
         * `CfnBackupPlan.LifecycleResourceTypeProperty.MoveToColdStorageAfterDays`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupplan-lifecycleresourcetype.html#cfn-backup-backupplan-lifecycleresourcetype-movetocoldstorageafterdays
         */
        readonly moveToColdStorageAfterDays?: number;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupSelection`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export interface CfnBackupSelectionProps {
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     */
    readonly backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     */
    readonly backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupSelection`
 *
 * @cloudformationResource AWS::Backup::BackupSelection
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html
 */
export declare class CfnBackupSelection extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupSelection";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnBackupSelection;
    /**
     * @cloudformationAttribute BackupPlanId
     */
    readonly attrBackupPlanId: string;
    /**
     * @cloudformationAttribute SelectionId
     */
    readonly attrSelectionId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupPlanId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupplanid
     */
    backupPlanId: string;
    /**
     * `AWS::Backup::BackupSelection.BackupSelection`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupselection.html#cfn-backup-backupselection-backupselection
     */
    backupSelection: CfnBackupSelection.BackupSelectionResourceTypeProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::Backup::BackupSelection`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupSelectionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBackupSelection {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html
     */
    interface BackupSelectionResourceTypeProperty {
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.IamRoleArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-iamrolearn
         */
        readonly iamRoleArn: string;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.ListOfTags`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-listoftags
         */
        readonly listOfTags?: Array<CfnBackupSelection.ConditionResourceTypeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.Resources`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-resources
         */
        readonly resources?: string[];
        /**
         * `CfnBackupSelection.BackupSelectionResourceTypeProperty.SelectionName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-backupselectionresourcetype.html#cfn-backup-backupselection-backupselectionresourcetype-selectionname
         */
        readonly selectionName: string;
    }
}
export declare namespace CfnBackupSelection {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html
     */
    interface ConditionResourceTypeProperty {
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionkey
         */
        readonly conditionKey: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionType`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditiontype
         */
        readonly conditionType: string;
        /**
         * `CfnBackupSelection.ConditionResourceTypeProperty.ConditionValue`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupselection-conditionresourcetype.html#cfn-backup-backupselection-conditionresourcetype-conditionvalue
         */
        readonly conditionValue: string;
    }
}
/**
 * Properties for defining a `AWS::Backup::BackupVault`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 */
export interface CfnBackupVaultProps {
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     */
    readonly backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     */
    readonly accessPolicy?: any | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     */
    readonly backupVaultTags?: any | cdk.IResolvable;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     */
    readonly encryptionKeyArn?: string;
    /**
     * `AWS::Backup::BackupVault.Notifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     */
    readonly notifications?: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Backup::BackupVault`
 *
 * @cloudformationResource AWS::Backup::BackupVault
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html
 */
export declare class CfnBackupVault extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Backup::BackupVault";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnBackupVault;
    /**
     * @cloudformationAttribute BackupVaultArn
     */
    readonly attrBackupVaultArn: string;
    /**
     * @cloudformationAttribute BackupVaultName
     */
    readonly attrBackupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.BackupVaultName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname
     */
    backupVaultName: string;
    /**
     * `AWS::Backup::BackupVault.AccessPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy
     */
    accessPolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.BackupVaultTags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags
     */
    backupVaultTags: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Backup::BackupVault.EncryptionKeyArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn
     */
    encryptionKeyArn: string | undefined;
    /**
     * `AWS::Backup::BackupVault.Notifications`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications
     */
    notifications: CfnBackupVault.NotificationObjectTypeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Backup::BackupVault`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBackupVaultProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnBackupVault {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html
     */
    interface NotificationObjectTypeProperty {
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.BackupVaultEvents`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-backupvaultevents
         */
        readonly backupVaultEvents: string[];
        /**
         * `CfnBackupVault.NotificationObjectTypeProperty.SNSTopicArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-snstopicarn
         */
        readonly snsTopicArn: string;
    }
}
