"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduledAction = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * Define a scheduled scaling action
 */
class ScheduledAction extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.minCapacity === undefined && props.maxCapacity === undefined && props.desiredCapacity === undefined) {
            throw new Error('At least one of minCapacity, maxCapacity, or desiredCapacity is required');
        }
        new autoscaling_generated_1.CfnScheduledAction(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            startTime: formatISO(props.startTime),
            endTime: formatISO(props.endTime),
            minSize: props.minCapacity,
            maxSize: props.maxCapacity,
            desiredCapacity: props.desiredCapacity,
            recurrence: props.schedule.expressionString,
        });
    }
}
exports.ScheduledAction = ScheduledAction;
function formatISO(date) {
    if (!date) {
        return undefined;
    }
    return date.getUTCFullYear() +
        '-' + pad(date.getUTCMonth() + 1) +
        '-' + pad(date.getUTCDate()) +
        'T' + pad(date.getUTCHours()) +
        ':' + pad(date.getUTCMinutes()) +
        ':' + pad(date.getUTCSeconds()) +
        'Z';
    function pad(num) {
        if (num < 10) {
            return '0' + num;
        }
        return num;
    }
}
//# sourceMappingURL=data:application/json;base64,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