"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicHook = void 0;
/**
 * Use an SNS topic as a hook target
 */
class TopicHook {
    constructor(topic) {
        this.topic = topic;
    }
    bind(_scope, lifecycleHook) {
        this.topic.grantPublish(lifecycleHook.role);
        return { notificationTargetArn: this.topic.topicArn };
    }
}
exports.TopicHook = TopicHook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRvcGljLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLFNBQVM7SUFDbEIsWUFBNkIsS0FBaUI7UUFBakIsVUFBSyxHQUFMLEtBQUssQ0FBWTtJQUM5QyxDQUFDO0lBQ00sSUFBSSxDQUFDLE1BQWlCLEVBQUUsYUFBeUM7UUFDcEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzVDLE9BQU8sRUFBRSxxQkFBcUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQzFELENBQUM7Q0FDSjtBQVBELDhCQU9DIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXV0b3NjYWxpbmcgZnJvbSBcIi4uLy4uL2F3cy1hdXRvc2NhbGluZ1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWF1dG9zY2FsaW5nJ1xuaW1wb3J0ICogYXMgc25zIGZyb20gXCIuLi8uLi9hd3Mtc25zXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3Mtc25zJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4vKipcbiAqIFVzZSBhbiBTTlMgdG9waWMgYXMgYSBob29rIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgVG9waWNIb29rIGltcGxlbWVudHMgYXV0b3NjYWxpbmcuSUxpZmVjeWNsZUhvb2tUYXJnZXQge1xuICAgIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMpIHtcbiAgICB9XG4gICAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIGxpZmVjeWNsZUhvb2s6IGF1dG9zY2FsaW5nLklMaWZlY3ljbGVIb29rKTogYXV0b3NjYWxpbmcuTGlmZWN5Y2xlSG9va1RhcmdldENvbmZpZyB7XG4gICAgICAgIHRoaXMudG9waWMuZ3JhbnRQdWJsaXNoKGxpZmVjeWNsZUhvb2sucm9sZSk7XG4gICAgICAgIHJldHVybiB7IG5vdGlmaWNhdGlvblRhcmdldEFybjogdGhpcy50b3BpYy50b3BpY0FybiB9O1xuICAgIH1cbn1cbiJdfQ==